/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import java.util.LinkedList;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.batch.rule.internal.DefaultRules;
import org.sonar.api.batch.rule.internal.NewRule;
import org.sonar.api.rule.RuleKey;

public class DefaultRulesTest {
    @Test
    public void testRepeatedInternalKey() {
        LinkedList<NewRule> newRules = new LinkedList<NewRule>();
        newRules.add(this.createRule("key1", "repo", "internal"));
        newRules.add(this.createRule("key2", "repo", "internal"));
        DefaultRules rules = new DefaultRules(newRules);
        Assertions.assertThat((Iterable)rules.findByInternalKey("repo", "internal")).hasSize(2);
        Assertions.assertThat((Object)rules.find(RuleKey.of((String)"repo", (String)"key1"))).isNotNull();
        Assertions.assertThat((Object)rules.find(RuleKey.of((String)"repo", (String)"key2"))).isNotNull();
        Assertions.assertThat((Iterable)rules.findByRepository("repo")).hasSize(2);
    }

    @Test
    public void testNonExistingKey() {
        LinkedList<NewRule> newRules = new LinkedList<NewRule>();
        newRules.add(this.createRule("key1", "repo", "internal"));
        newRules.add(this.createRule("key2", "repo", "internal"));
        DefaultRules rules = new DefaultRules(newRules);
        Assertions.assertThat((Iterable)rules.findByInternalKey("xx", "xx")).hasSize(0);
        Assertions.assertThat((Object)rules.find(RuleKey.of((String)"xxx", (String)"xx"))).isNull();
        Assertions.assertThat((Iterable)rules.findByRepository("xxxx")).hasSize(0);
    }

    @Test
    public void testRepeatedRule() {
        LinkedList<NewRule> newRules = new LinkedList<NewRule>();
        newRules.add(this.createRule("key", "repo", "internal"));
        newRules.add(this.createRule("key", "repo", "internal"));
        DefaultRules rules = new DefaultRules(newRules);
        Assertions.assertThat((Object)rules.find(RuleKey.of((String)"repo", (String)"key"))).isNotNull();
    }

    private NewRule createRule(String key, String repo, String internalKey) {
        RuleKey ruleKey = RuleKey.of((String)repo, (String)key);
        NewRule newRule = new NewRule(ruleKey);
        newRule.setInternalKey(internalKey);
        return newRule;
    }
}

