/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.Severity;

public class ActiveRulesBuilderTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void no_rules() {
        ActiveRulesBuilder builder = new ActiveRulesBuilder();
        ActiveRules rules = builder.build();
        Assertions.assertThat((Iterable)rules.findAll()).isEmpty();
    }

    @Test
    public void build_rules() {
        ActiveRules activeRules = new ActiveRulesBuilder().create(RuleKey.of((String)"squid", (String)"S0001")).setName("My Rule").setSeverity("CRITICAL").setInternalKey("__S0001__").setParam("min", "20").activate().create(RuleKey.of((String)"squid", (String)"S0002")).activate().create(RuleKey.of((String)"findbugs", (String)"NPE")).setInternalKey(null).setSeverity(null).setParam("foo", null).activate().build();
        Assertions.assertThat((Iterable)activeRules.findAll()).hasSize(3);
        Assertions.assertThat((Iterable)activeRules.findByRepository("squid")).hasSize(2);
        Assertions.assertThat((Iterable)activeRules.findByRepository("findbugs")).hasSize(1);
        Assertions.assertThat((Object)activeRules.findByInternalKey("squid", "__S0001__")).isNotNull();
        Assertions.assertThat((Iterable)activeRules.findByRepository("unknown")).isEmpty();
        ActiveRule squid1 = activeRules.find(RuleKey.of((String)"squid", (String)"S0001"));
        Assertions.assertThat((String)squid1.ruleKey().repository()).isEqualTo((Object)"squid");
        Assertions.assertThat((String)squid1.ruleKey().rule()).isEqualTo((Object)"S0001");
        Assertions.assertThat((String)squid1.severity()).isEqualTo((Object)"CRITICAL");
        Assertions.assertThat((String)squid1.internalKey()).isEqualTo((Object)"__S0001__");
        Assertions.assertThat((Map)squid1.params()).hasSize(1);
        Assertions.assertThat((String)squid1.param("min")).isEqualTo((Object)"20");
        ActiveRule squid2 = activeRules.find(RuleKey.of((String)"squid", (String)"S0002"));
        Assertions.assertThat((String)squid2.ruleKey().repository()).isEqualTo((Object)"squid");
        Assertions.assertThat((String)squid2.ruleKey().rule()).isEqualTo((Object)"S0002");
        Assertions.assertThat((String)squid2.severity()).isEqualTo((Object)Severity.defaultSeverity());
        Assertions.assertThat((Map)squid2.params()).isEmpty();
        ActiveRule findbugsRule = activeRules.find(RuleKey.of((String)"findbugs", (String)"NPE"));
        Assertions.assertThat((String)findbugsRule.severity()).isEqualTo((Object)Severity.defaultSeverity());
        Assertions.assertThat((String)findbugsRule.internalKey()).isNull();
        Assertions.assertThat((Map)findbugsRule.params()).isEmpty();
    }

    @Test
    public void fail_to_add_twice_the_same_rule() {
        ActiveRulesBuilder builder = new ActiveRulesBuilder();
        builder.create(RuleKey.of((String)"squid", (String)"S0001")).activate();
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Rule 'squid:S0001' is already activated");
        builder.create(RuleKey.of((String)"squid", (String)"S0001")).activate();
    }
}

