/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.CheckWithKey;
import org.sonar.api.batch.rule.CheckWithOverriddenPropertyKey;
import org.sonar.api.batch.rule.CheckWithPrimitiveProperties;
import org.sonar.api.batch.rule.CheckWithStringProperty;
import org.sonar.api.batch.rule.CheckWithUnsupportedPropertyType;
import org.sonar.api.batch.rule.CheckWithoutProperties;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.SonarException;

public class CheckFactoryTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    ActiveRulesBuilder builder = new ActiveRulesBuilder();

    @Test
    public void no_checks_are_enabled() {
        CheckFactory checkFactory = new CheckFactory(this.builder.build());
        Checks checks = checkFactory.create("squid").addAnnotatedChecks(new Object[]{CheckWithoutProperties.class});
        Assertions.assertThat((Iterable)checks.all()).isEmpty();
    }

    @Test
    public void class_name_as_check_key() {
        RuleKey ruleKey = RuleKey.of((String)"squid", (String)"org.sonar.api.batch.rule.CheckWithoutProperties");
        this.builder.create(ruleKey).activate();
        CheckFactory checkFactory = new CheckFactory(this.builder.build());
        Checks checks = checkFactory.create("squid").addAnnotatedChecks(new Object[]{CheckWithoutProperties.class});
        Object check = checks.of(ruleKey);
        Assertions.assertThat((Object)check).isInstanceOf(CheckWithoutProperties.class);
        Assertions.assertThat((Iterable)checks.all()).containsOnly(new Object[]{check});
        Assertions.assertThat((Comparable)checks.ruleKey(check)).isEqualTo((Object)ruleKey);
    }

    @Test
    public void param_as_string_field() {
        RuleKey ruleKey = RuleKey.of((String)"squid", (String)"org.sonar.api.batch.rule.CheckWithStringProperty");
        this.builder.create(ruleKey).setParam("pattern", "foo").activate();
        CheckFactory checkFactory = new CheckFactory(this.builder.build());
        Checks checks = checkFactory.create("squid").addAnnotatedChecks(new Object[]{CheckWithStringProperty.class});
        Object check = checks.of(ruleKey);
        Assertions.assertThat((Object)check).isInstanceOf(CheckWithStringProperty.class);
        Assertions.assertThat((String)((CheckWithStringProperty)check).getPattern()).isEqualTo((Object)"foo");
    }

    @Test
    public void fail_if_missing_field() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("The field 'unknown' does not exist or is not annotated with @RuleProperty in the class org.sonar.api.batch.rule.CheckWithStringProperty");
        RuleKey ruleKey = RuleKey.of((String)"squid", (String)"org.sonar.api.batch.rule.CheckWithStringProperty");
        this.builder.create(ruleKey).setParam("unknown", "foo").activate();
        CheckFactory checkFactory = new CheckFactory(this.builder.build());
        checkFactory.create("squid").addAnnotatedChecks(new Object[]{CheckWithStringProperty.class});
    }

    @Test
    public void param_as_primitive_fields() {
        RuleKey ruleKey = RuleKey.of((String)"squid", (String)"org.sonar.api.batch.rule.CheckWithPrimitiveProperties");
        this.builder.create(ruleKey).setParam("max", "300").setParam("ignore", "true").activate();
        CheckFactory checkFactory = new CheckFactory(this.builder.build());
        Checks checks = checkFactory.create("squid").addAnnotatedChecks(new Object[]{CheckWithPrimitiveProperties.class});
        Object check = checks.of(ruleKey);
        Assertions.assertThat((Object)check).isInstanceOf(CheckWithPrimitiveProperties.class);
        Assertions.assertThat((int)((CheckWithPrimitiveProperties)check).getMax()).isEqualTo(300);
        Assertions.assertThat((boolean)((CheckWithPrimitiveProperties)check).isIgnore()).isTrue();
    }

    @Test
    public void param_as_inherited_field() {
        RuleKey ruleKey = RuleKey.of((String)"squid", (String)"org.sonar.api.batch.rule.CheckWithPrimitiveProperties");
        this.builder.create(ruleKey).setParam("max", "300").activate();
        CheckFactory checkFactory = new CheckFactory(this.builder.build());
        Checks checks = checkFactory.create("squid").addAnnotatedChecks(new Object[]{CheckWithPrimitiveProperties.class});
        Object check = checks.of(ruleKey);
        Assertions.assertThat((Object)check).isInstanceOf(CheckWithPrimitiveProperties.class);
        Assertions.assertThat((int)((CheckWithPrimitiveProperties)check).getMax()).isEqualTo(300);
    }

    @Test
    public void use_template_rule_key() {
        RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S0001_123");
        this.builder.create(ruleKey).setTemplateRuleKey("S0001").activate();
        CheckFactory checkFactory = new CheckFactory(this.builder.build());
        Checks checks = checkFactory.create("squid").addAnnotatedChecks(new Object[]{CheckWithKey.class});
        Object check = checks.of(ruleKey);
        Assertions.assertThat((Object)check).isInstanceOf(CheckWithKey.class);
        Assertions.assertThat((Object)checks.of(ruleKey)).isSameAs(check);
        Assertions.assertThat((Comparable)checks.ruleKey(check)).isEqualTo((Object)ruleKey);
        Assertions.assertThat((Iterable)checks.all()).containsOnly(new Object[]{check});
    }

    @Test
    public void fail_if_field_type_is_not_supported() {
        this.thrown.expect(SonarException.class);
        RuleKey ruleKey = RuleKey.of((String)"squid", (String)"org.sonar.api.batch.rule.CheckWithUnsupportedPropertyType");
        this.builder.create(ruleKey).setParam("max", "300").activate();
        CheckFactory checkFactory = new CheckFactory(this.builder.build());
        checkFactory.create("squid").addAnnotatedChecks(new Object[]{CheckWithUnsupportedPropertyType.class});
    }

    @Test
    public void override_field_key() {
        RuleKey ruleKey = RuleKey.of((String)"squid", (String)"org.sonar.api.batch.rule.CheckWithOverriddenPropertyKey");
        this.builder.create(ruleKey).setParam("maximum", "300").activate();
        CheckFactory checkFactory = new CheckFactory(this.builder.build());
        Checks checks = checkFactory.create("squid").addAnnotatedChecks(new Object[]{CheckWithOverriddenPropertyKey.class});
        Object check = checks.of(ruleKey);
        Assertions.assertThat((Object)check).isInstanceOf(CheckWithOverriddenPropertyKey.class);
        Assertions.assertThat((int)((CheckWithOverriddenPropertyKey)check).getMax()).isEqualTo(300);
    }

    @Test
    public void checks_as_objects() {
        RuleKey ruleKey = RuleKey.of((String)"squid", (String)"org.sonar.api.batch.rule.CheckWithStringProperty");
        this.builder.create(ruleKey).setParam("pattern", "foo").activate();
        CheckFactory checkFactory = new CheckFactory(this.builder.build());
        CheckWithStringProperty check = new CheckWithStringProperty();
        Checks checks = checkFactory.create("squid").addAnnotatedChecks(new Object[]{check});
        Object createdCheck = checks.of(ruleKey);
        Assertions.assertThat((Object)createdCheck).isSameAs((Object)check);
        Assertions.assertThat((String)((CheckWithStringProperty)createdCheck).getPattern()).isEqualTo((Object)"foo");
    }
}

