/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.IOException;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.sonar.api.batch.fs.IndexedFile;
import org.sonar.api.batch.fs.internal.DefaultIndexedFile;
import org.sonar.api.batch.fs.internal.PathPattern;

public class PathPatternTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private Path moduleBasePath;

    @Before
    public void setUp() throws IOException {
        this.moduleBasePath = this.temp.newFolder().toPath();
    }

    @Test
    public void match_relative_path() {
        PathPattern pattern = PathPattern.create((String)"**/*Foo.java");
        Assertions.assertThat((String)pattern.toString()).isEqualTo((Object)"**/*Foo.java");
        DefaultIndexedFile indexedFile = new DefaultIndexedFile("ABCDE", this.moduleBasePath, "src/main/java/org/MyFoo.java");
        Assertions.assertThat((boolean)pattern.match((IndexedFile)indexedFile)).isTrue();
        indexedFile = new DefaultIndexedFile("ABCDE", this.moduleBasePath, "src/main/java/org/MyFoo.JAVA");
        Assertions.assertThat((boolean)pattern.match((IndexedFile)indexedFile)).isFalse();
        indexedFile = new DefaultIndexedFile("ABCDE", this.moduleBasePath, "src/main/java/org/Other.java");
        Assertions.assertThat((boolean)pattern.match((IndexedFile)indexedFile)).isFalse();
    }

    @Test
    public void match_relative_path_and_insensitive_file_extension() throws Exception {
        PathPattern pattern = PathPattern.create((String)"**/*Foo.java");
        DefaultIndexedFile indexedFile = new DefaultIndexedFile("ABCDE", this.moduleBasePath, "src/main/java/org/MyFoo.JAVA");
        Assertions.assertThat((boolean)pattern.match((IndexedFile)indexedFile, false)).isTrue();
        indexedFile = new DefaultIndexedFile("ABCDE", this.moduleBasePath, "src/main/java/org/Other.java");
        Assertions.assertThat((boolean)pattern.match((IndexedFile)indexedFile, false)).isFalse();
    }

    @Test
    public void match_absolute_path() throws Exception {
        PathPattern pattern = PathPattern.create((String)"file:**/src/main/**Foo.java");
        Assertions.assertThat((String)pattern.toString()).isEqualTo((Object)"file:**/src/main/**Foo.java");
        DefaultIndexedFile indexedFile = new DefaultIndexedFile("ABCDE", this.moduleBasePath, "src/main/java/org/MyFoo.java");
        Assertions.assertThat((boolean)pattern.match((IndexedFile)indexedFile)).isTrue();
        indexedFile = new DefaultIndexedFile("ABCDE", this.moduleBasePath, "src/main/java/org/MyFoo.JAVA");
        Assertions.assertThat((boolean)pattern.match((IndexedFile)indexedFile)).isFalse();
        indexedFile = new DefaultIndexedFile("ABCDE", this.moduleBasePath, "src/main/java/org/Other.java");
        Assertions.assertThat((boolean)pattern.match((IndexedFile)indexedFile)).isFalse();
    }

    @Test
    public void match_absolute_path_and_insensitive_file_extension() throws Exception {
        PathPattern pattern = PathPattern.create((String)"file:**/src/main/**Foo.java");
        Assertions.assertThat((String)pattern.toString()).isEqualTo((Object)"file:**/src/main/**Foo.java");
        DefaultIndexedFile indexedFile = new DefaultIndexedFile("ABCDE", this.moduleBasePath, "src/main/java/org/MyFoo.JAVA");
        Assertions.assertThat((boolean)pattern.match((IndexedFile)indexedFile, false)).isTrue();
        indexedFile = new DefaultIndexedFile("ABCDE", this.moduleBasePath, "src/main/java/org/Other.JAVA");
        Assertions.assertThat((boolean)pattern.match((IndexedFile)indexedFile, false)).isFalse();
    }

    @Test
    public void create_array_of_patterns() {
        Object[] patterns = PathPattern.create((String[])new String[]{"**/src/main/**Foo.java", "file:**/src/main/**Bar.java"});
        Assertions.assertThat((Object[])patterns).hasSize(2);
        Assertions.assertThat((String)patterns[0].toString()).isEqualTo((Object)"**/src/main/**Foo.java");
        Assertions.assertThat((String)patterns[1].toString()).isEqualTo((Object)"file:**/src/main/**Bar.java");
    }
}

