/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.internal.FalsePredicate;
import org.sonar.api.batch.fs.internal.OrPredicate;
import org.sonar.api.batch.fs.internal.PathPattern;
import org.sonar.api.batch.fs.internal.PathPatternPredicate;
import org.sonar.api.batch.fs.internal.TruePredicate;

public class OrPredicateTest {
    @Test
    public void flattenNestedOr() {
        PathPatternPredicate pathPatternPredicate1 = new PathPatternPredicate(PathPattern.create((String)"foo1/**"));
        PathPatternPredicate pathPatternPredicate2 = new PathPatternPredicate(PathPattern.create((String)"foo2/**"));
        PathPatternPredicate pathPatternPredicate3 = new PathPatternPredicate(PathPattern.create((String)"foo3/**"));
        FilePredicate orPredicate = OrPredicate.create(Arrays.asList(pathPatternPredicate1, OrPredicate.create(Arrays.asList(pathPatternPredicate2, pathPatternPredicate3))));
        Assertions.assertThat((Iterable)((OrPredicate)orPredicate).predicates()).containsExactly((Object[])new FilePredicate[]{pathPatternPredicate1, pathPatternPredicate2, pathPatternPredicate3});
    }

    @Test
    public void simplifyOrExpressionsWhenEmpty() {
        FilePredicate orPredicate = OrPredicate.create(Arrays.asList(new FilePredicate[0]));
        Assertions.assertThat((Object)orPredicate).isEqualTo((Object)TruePredicate.TRUE);
    }

    @Test
    public void simplifyOrExpressionsWhenFalse() {
        PathPatternPredicate pathPatternPredicate1 = new PathPatternPredicate(PathPattern.create((String)"foo1/**"));
        PathPatternPredicate pathPatternPredicate2 = new PathPatternPredicate(PathPattern.create((String)"foo2/**"));
        FilePredicate andPredicate = OrPredicate.create(Arrays.asList(pathPatternPredicate1, FalsePredicate.FALSE, pathPatternPredicate2));
        Assertions.assertThat((Iterable)((OrPredicate)andPredicate).predicates()).containsExactly((Object[])new FilePredicate[]{pathPatternPredicate1, pathPatternPredicate2});
    }

    @Test
    public void simplifyAndExpressionsWhenTrue() {
        PathPatternPredicate pathPatternPredicate1 = new PathPatternPredicate(PathPattern.create((String)"foo1/**"));
        PathPatternPredicate pathPatternPredicate2 = new PathPatternPredicate(PathPattern.create((String)"foo2/**"));
        FilePredicate andPredicate = OrPredicate.create(Arrays.asList(pathPatternPredicate1, TruePredicate.TRUE, pathPatternPredicate2));
        Assertions.assertThat((Object)andPredicate).isEqualTo((Object)TruePredicate.TRUE);
    }
}

