/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.FilenamePredicate;

public class FilenamePredicateTest {
    @Test
    public void should_match_file_by_filename() throws IOException {
        String filename = "some name";
        InputFile inputFile = (InputFile)Mockito.mock(InputFile.class);
        Mockito.when((Object)inputFile.file()).thenReturn((Object)this.newDummyFile(filename));
        Assertions.assertThat((boolean)new FilenamePredicate(filename).apply(inputFile)).isTrue();
    }

    @Test
    public void should_not_match_file_by_different_filename() throws IOException {
        String filename = "some name";
        InputFile inputFile = (InputFile)Mockito.mock(InputFile.class);
        Mockito.when((Object)inputFile.file()).thenReturn((Object)this.newDummyFile(filename + "x"));
        Assertions.assertThat((boolean)new FilenamePredicate(filename).apply(inputFile)).isFalse();
    }

    @Test
    public void should_find_matching_file_in_index() throws IOException {
        String filename = "some name";
        InputFile inputFile = (InputFile)Mockito.mock(InputFile.class);
        Mockito.when((Object)inputFile.file()).thenReturn((Object)this.newDummyFile(filename));
        FileSystem.Index index = (FileSystem.Index)Mockito.mock(FileSystem.Index.class);
        Mockito.when((Object)index.getFilesByName(filename)).thenReturn(Collections.singleton(inputFile));
        Assertions.assertThat((Iterable)new FilenamePredicate(filename).get(index)).containsOnly((Object[])new InputFile[]{inputFile});
    }

    private File newDummyFile(String filename) {
        return new File("dummy parent", filename);
    }
}

