/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.FileExtensionPredicate;

public class FileExtensionPredicateTest {
    @Test
    public void should_match_correct_extension() throws IOException {
        FileExtensionPredicate predicate = new FileExtensionPredicate("bat");
        Assertions.assertThat((boolean)predicate.apply(this.mockWithName("prog.bat"))).isTrue();
        Assertions.assertThat((boolean)predicate.apply(this.mockWithName("prog.bat.bat"))).isTrue();
    }

    @Test
    public void should_not_match_incorrect_extension() throws IOException {
        FileExtensionPredicate predicate = new FileExtensionPredicate("bat");
        Assertions.assertThat((boolean)predicate.apply(this.mockWithName("prog.batt"))).isFalse();
        Assertions.assertThat((boolean)predicate.apply(this.mockWithName("prog.abat"))).isFalse();
        Assertions.assertThat((boolean)predicate.apply(this.mockWithName("prog."))).isFalse();
        Assertions.assertThat((boolean)predicate.apply(this.mockWithName("prog.bat."))).isFalse();
        Assertions.assertThat((boolean)predicate.apply(this.mockWithName("prog.bat.batt"))).isFalse();
        Assertions.assertThat((boolean)predicate.apply(this.mockWithName("prog"))).isFalse();
    }

    @Test
    public void should_match_correct_extension_case_insensitively() throws IOException {
        FileExtensionPredicate predicate = new FileExtensionPredicate("jAVa");
        Assertions.assertThat((boolean)predicate.apply(this.mockWithName("Program.java"))).isTrue();
        Assertions.assertThat((boolean)predicate.apply(this.mockWithName("Program.JAVA"))).isTrue();
        Assertions.assertThat((boolean)predicate.apply(this.mockWithName("Program.Java"))).isTrue();
        Assertions.assertThat((boolean)predicate.apply(this.mockWithName("Program.JaVa"))).isTrue();
    }

    @Test
    public void test_empty_extension() {
        Assertions.assertThat((String)FileExtensionPredicate.getExtension((String)"prog")).isEmpty();
        Assertions.assertThat((String)FileExtensionPredicate.getExtension((String)"prog.")).isEmpty();
        Assertions.assertThat((String)FileExtensionPredicate.getExtension((String)".")).isEmpty();
    }

    private InputFile mockWithName(String filename) throws IOException {
        InputFile inputFile = (InputFile)Mockito.mock(InputFile.class);
        Mockito.when((Object)inputFile.file()).thenReturn((Object)new File("dummy parent", filename));
        return inputFile;
    }
}

