/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultIndexedFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.FileMetadata;
import org.sonar.api.batch.fs.internal.Metadata;

public class DefaultInputFileTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void test() throws Exception {
        Path baseDir = this.temp.newFolder().toPath();
        Metadata metadata = new Metadata(42, 42, "", new int[0], 0);
        DefaultIndexedFile indexedFile = new DefaultIndexedFile("ABCDE", baseDir, "src/Foo.php", InputFile.Type.TEST, 0).setLanguage("php");
        DefaultInputFile inputFile = new DefaultInputFile(indexedFile, f -> f.setMetadata(metadata)).setStatus(InputFile.Status.ADDED).setCharset(StandardCharsets.ISO_8859_1);
        Assertions.assertThat((String)inputFile.relativePath()).isEqualTo((Object)"src/Foo.php");
        Assertions.assertThat((File)new File(inputFile.relativePath())).isRelative();
        Assertions.assertThat((String)inputFile.absolutePath()).endsWith((CharSequence)"Foo.php");
        Assertions.assertThat((File)new File(inputFile.absolutePath())).isAbsolute();
        Assertions.assertThat((String)inputFile.language()).isEqualTo((Object)"php");
        Assertions.assertThat((Comparable)inputFile.status()).isEqualTo((Object)InputFile.Status.ADDED);
        Assertions.assertThat((Comparable)inputFile.type()).isEqualTo((Object)InputFile.Type.TEST);
        Assertions.assertThat((int)inputFile.lines()).isEqualTo(42);
        Assertions.assertThat((Comparable)inputFile.charset()).isEqualTo((Object)StandardCharsets.ISO_8859_1);
    }

    @Test
    public void test_content() throws IOException {
        Path baseDir = this.temp.newFolder().toPath();
        Path testFile = baseDir.resolve("src").resolve("Foo.php");
        Files.createDirectories(testFile.getParent(), new FileAttribute[0]);
        Files.write(testFile, "test string".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Metadata metadata = new Metadata(42, 30, "", new int[0], 0);
        DefaultInputFile inputFile = new DefaultInputFile(new DefaultIndexedFile("ABCDE", baseDir, "src/Foo.php", InputFile.Type.TEST, 0).setLanguage("php"), f -> f.setMetadata(metadata)).setStatus(InputFile.Status.ADDED).setCharset(StandardCharsets.ISO_8859_1);
        Assertions.assertThat((String)inputFile.contents()).isEqualTo((Object)"test string");
        try (InputStream inputStream = inputFile.inputStream();){
            String result = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining());
            Assertions.assertThat((String)result).isEqualTo((Object)"test string");
        }
    }

    @Test
    public void test_equals_and_hashcode() throws Exception {
        DefaultInputFile f1 = new DefaultInputFile(new DefaultIndexedFile("ABCDE", Paths.get("module", new String[0]), "src/Foo.php"), f -> {
            Metadata cfr_ignored_0 = (Metadata)Mockito.mock(Metadata.class);
        });
        DefaultInputFile f1a = new DefaultInputFile(new DefaultIndexedFile("ABCDE", Paths.get("module", new String[0]), "src/Foo.php"), f -> {
            Metadata cfr_ignored_0 = (Metadata)Mockito.mock(Metadata.class);
        });
        DefaultInputFile f2 = new DefaultInputFile(new DefaultIndexedFile("ABCDE", Paths.get("module", new String[0]), "src/Bar.php"), f -> {
            Metadata cfr_ignored_0 = (Metadata)Mockito.mock(Metadata.class);
        });
        Assertions.assertThat((Object)f1).isEqualTo((Object)f1);
        Assertions.assertThat((Object)f1).isEqualTo((Object)f1a);
        Assertions.assertThat((Object)f1).isNotEqualTo((Object)f2);
        Assertions.assertThat((boolean)f1.equals((Object)"foo")).isFalse();
        Assertions.assertThat((boolean)f1.equals(null)).isFalse();
        Assertions.assertThat((int)f1.hashCode()).isEqualTo(f1.hashCode());
        Assertions.assertThat((int)f1.hashCode()).isEqualTo(f1a.hashCode());
    }

    @Test
    public void test_toString() throws Exception {
        DefaultInputFile file = new DefaultInputFile(new DefaultIndexedFile("ABCDE", Paths.get("module", new String[0]), "src/Foo.php"), f -> {
            Metadata cfr_ignored_0 = (Metadata)Mockito.mock(Metadata.class);
        });
        Assertions.assertThat((String)file.toString()).isEqualTo((Object)"[moduleKey=ABCDE, relative=src/Foo.php, basedir=module]");
    }

    @Test
    public void checkValidPointer() {
        Metadata metadata = new Metadata(2, 2, "", new int[]{0, 10}, 15);
        DefaultInputFile file = new DefaultInputFile(new DefaultIndexedFile("ABCDE", Paths.get("module", new String[0]), "src/Foo.php"), f -> f.setMetadata(metadata));
        Assertions.assertThat((int)file.newPointer(1, 0).line()).isEqualTo(1);
        Assertions.assertThat((int)file.newPointer(1, 0).lineOffset()).isEqualTo(0);
        file.newPointer(1, 9);
        file.newPointer(2, 0);
        file.newPointer(2, 5);
        try {
            file.newPointer(0, 1);
            Assert.fail();
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessage("0 is not a valid line for a file");
        }
        try {
            file.newPointer(3, 1);
            Assert.fail();
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessage("3 is not a valid line for pointer. File [moduleKey=ABCDE, relative=src/Foo.php, basedir=module] has 2 line(s)");
        }
        try {
            file.newPointer(1, -1);
            Assert.fail();
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessage("-1 is not a valid line offset for a file");
        }
        try {
            file.newPointer(1, 10);
            Assert.fail();
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessage("10 is not a valid line offset for pointer. File [moduleKey=ABCDE, relative=src/Foo.php, basedir=module] has 9 character(s) at line 1");
        }
    }

    @Test
    public void checkValidPointerUsingGlobalOffset() {
        Metadata metadata = new Metadata(2, 2, "", new int[]{0, 10}, 15);
        DefaultInputFile file = new DefaultInputFile(new DefaultIndexedFile("ABCDE", Paths.get("module", new String[0]), "src/Foo.php"), f -> f.setMetadata(metadata));
        Assertions.assertThat((int)file.newPointer(0).line()).isEqualTo(1);
        Assertions.assertThat((int)file.newPointer(0).lineOffset()).isEqualTo(0);
        Assertions.assertThat((int)file.newPointer(9).line()).isEqualTo(1);
        Assertions.assertThat((int)file.newPointer(9).lineOffset()).isEqualTo(9);
        Assertions.assertThat((int)file.newPointer(10).line()).isEqualTo(2);
        Assertions.assertThat((int)file.newPointer(10).lineOffset()).isEqualTo(0);
        Assertions.assertThat((int)file.newPointer(15).line()).isEqualTo(2);
        Assertions.assertThat((int)file.newPointer(15).lineOffset()).isEqualTo(5);
        try {
            file.newPointer(-1);
            Assert.fail();
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessage("-1 is not a valid offset for a file");
        }
        try {
            file.newPointer(16);
            Assert.fail();
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessage("16 is not a valid offset for file [moduleKey=ABCDE, relative=src/Foo.php, basedir=module]. Max offset is 15");
        }
    }

    @Test
    public void checkValidRange() {
        Metadata metadata = new FileMetadata().readMetadata((Reader)new StringReader("bla bla a\nabcde"));
        DefaultInputFile file = new DefaultInputFile(new DefaultIndexedFile("ABCDE", Paths.get("module", new String[0]), "src/Foo.php"), f -> f.setMetadata(metadata));
        Assertions.assertThat((int)file.newRange(file.newPointer(1, 0), file.newPointer(2, 1)).start().line()).isEqualTo(1);
        file.newRange(file.newPointer(1, 0), file.newPointer(1, 1));
        file.newRange(file.newPointer(1, 0), file.newPointer(1, 9));
        file.newRange(file.newPointer(1, 0), file.newPointer(2, 0));
        Assertions.assertThat((Object)file.newRange(file.newPointer(1, 0), file.newPointer(2, 5))).isEqualTo((Object)file.newRange(0, 15));
        try {
            file.newRange(file.newPointer(1, 0), file.newPointer(1, 0));
            Assert.fail();
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessage("Start pointer [line=1, lineOffset=0] should be before end pointer [line=1, lineOffset=0]");
        }
        try {
            file.newRange(file.newPointer(1, 0), file.newPointer(1, 10));
            Assert.fail();
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessage("10 is not a valid line offset for pointer. File [moduleKey=ABCDE, relative=src/Foo.php, basedir=module] has 9 character(s) at line 1");
        }
    }

    @Test
    public void selectLine() {
        Metadata metadata = new FileMetadata().readMetadata((Reader)new StringReader("bla bla a\nabcde\n\nabc"));
        DefaultInputFile file = new DefaultInputFile(new DefaultIndexedFile("ABCDE", Paths.get("module", new String[0]), "src/Foo.php"), f -> f.setMetadata(metadata));
        Assertions.assertThat((int)file.selectLine(1).start().line()).isEqualTo(1);
        Assertions.assertThat((int)file.selectLine(1).start().lineOffset()).isEqualTo(0);
        Assertions.assertThat((int)file.selectLine(1).end().line()).isEqualTo(1);
        Assertions.assertThat((int)file.selectLine(1).end().lineOffset()).isEqualTo(9);
        Assertions.assertThat((int)file.selectLine(3).start().line()).isEqualTo(3);
        Assertions.assertThat((int)file.selectLine(3).start().lineOffset()).isEqualTo(0);
        Assertions.assertThat((int)file.selectLine(3).end().line()).isEqualTo(3);
        Assertions.assertThat((int)file.selectLine(3).end().lineOffset()).isEqualTo(0);
        try {
            file.selectLine(5);
            Assert.fail();
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessage("5 is not a valid line for pointer. File [moduleKey=ABCDE, relative=src/Foo.php, basedir=module] has 4 line(s)");
        }
    }

    @Test
    public void checkValidRangeUsingGlobalOffset() {
        Metadata metadata = new Metadata(2, 2, "", new int[]{0, 10}, 15);
        DefaultInputFile file = new DefaultInputFile(new DefaultIndexedFile("ABCDE", Paths.get("module", new String[0]), "src/Foo.php"), f -> f.setMetadata(metadata));
        TextRange newRange = file.newRange(10, 13);
        Assertions.assertThat((int)newRange.start().line()).isEqualTo(2);
        Assertions.assertThat((int)newRange.start().lineOffset()).isEqualTo(0);
        Assertions.assertThat((int)newRange.end().line()).isEqualTo(2);
        Assertions.assertThat((int)newRange.end().lineOffset()).isEqualTo(3);
    }

    @Test
    public void testRangeOverlap() {
        Metadata metadata = new Metadata(2, 2, "", new int[]{0, 10}, 15);
        DefaultInputFile file = new DefaultInputFile(new DefaultIndexedFile("ABCDE", Paths.get("module", new String[0]), "src/Foo.php"), f -> f.setMetadata(metadata));
        Assertions.assertThat((boolean)file.newRange(file.newPointer(1, 0), file.newPointer(1, 1)).overlap(file.newRange(file.newPointer(1, 0), file.newPointer(1, 1)))).isTrue();
        Assertions.assertThat((boolean)file.newRange(file.newPointer(1, 0), file.newPointer(1, 1)).overlap(file.newRange(file.newPointer(1, 0), file.newPointer(1, 2)))).isTrue();
        Assertions.assertThat((boolean)file.newRange(file.newPointer(1, 0), file.newPointer(1, 1)).overlap(file.newRange(file.newPointer(1, 1), file.newPointer(1, 2)))).isFalse();
        Assertions.assertThat((boolean)file.newRange(file.newPointer(1, 2), file.newPointer(1, 3)).overlap(file.newRange(file.newPointer(1, 0), file.newPointer(1, 2)))).isFalse();
    }
}

