/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.sonar.api.batch.fs.internal.DefaultInputDir;

public class DefaultInputDirTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void test() throws Exception {
        File baseDir = this.temp.newFolder();
        DefaultInputDir inputDir = new DefaultInputDir("ABCDE", "src").setModuleBaseDir(baseDir.toPath());
        Assertions.assertThat((String)inputDir.key()).isEqualTo((Object)"ABCDE:src");
        Assertions.assertThat((String)inputDir.file().getAbsolutePath()).isEqualTo((Object)new File(baseDir, "src").getAbsolutePath());
        Assertions.assertThat((String)inputDir.relativePath()).isEqualTo((Object)"src");
        Assertions.assertThat((File)new File(inputDir.relativePath())).isRelative();
        Assertions.assertThat((String)inputDir.absolutePath()).endsWith((CharSequence)"src");
        Assertions.assertThat((File)new File(inputDir.absolutePath())).isAbsolute();
    }

    @Test
    public void testEqualsAndHashCode() throws Exception {
        DefaultInputDir inputDir1 = new DefaultInputDir("ABCDE", "src");
        DefaultInputDir inputDir2 = new DefaultInputDir("ABCDE", "src");
        Assertions.assertThat((boolean)inputDir1.equals((Object)inputDir1)).isTrue();
        Assertions.assertThat((boolean)inputDir1.equals((Object)inputDir2)).isTrue();
        Assertions.assertThat((boolean)inputDir1.equals((Object)"foo")).isFalse();
        Assertions.assertThat((int)inputDir1.hashCode()).isEqualTo(63545559);
        Assertions.assertThat((String)inputDir1.toString()).contains(new CharSequence[]{"[moduleKey=ABCDE, relative=src, basedir=null"});
    }
}

