/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;

public class DefaultFileSystemTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private DefaultFileSystem fs;
    private File basedir;

    @Before
    public void prepare() throws Exception {
        this.basedir = this.temp.newFolder();
        this.fs = new DefaultFileSystem(this.basedir.toPath());
    }

    @Test
    public void test_directories() throws Exception {
        Assertions.assertThat((File)this.fs.baseDir()).isAbsolute().isDirectory().exists();
        Assertions.assertThat((String)this.fs.baseDir().getCanonicalPath()).isEqualTo((Object)this.basedir.getCanonicalPath());
        File workdir = this.temp.newFolder();
        this.fs.setWorkDir(workdir);
        Assertions.assertThat((File)this.fs.workDir()).isAbsolute().isDirectory().exists();
        Assertions.assertThat((String)this.fs.workDir().getCanonicalPath()).isEqualTo((Object)workdir.getCanonicalPath());
    }

    @Test
    public void test_encoding() throws Exception {
        Assertions.assertThat((boolean)this.fs.isDefaultJvmEncoding()).isTrue();
        Assertions.assertThat((Comparable)this.fs.encoding()).isEqualTo((Object)Charset.defaultCharset());
        this.fs.setEncoding(Charset.forName("ISO-8859-1"));
        Assertions.assertThat((Comparable)this.fs.encoding()).isEqualTo((Object)Charset.forName("ISO-8859-1"));
        Assertions.assertThat((boolean)this.fs.isDefaultJvmEncoding()).isFalse();
    }

    @Test
    public void add_languages() {
        Assertions.assertThat((Iterable)this.fs.languages()).isEmpty();
        this.fs.addLanguages("java", new String[]{"php", "cobol"});
        Assertions.assertThat((Iterable)this.fs.languages()).containsOnly((Object[])new String[]{"cobol", "java", "php"});
    }

    @Test
    public void files() {
        Assertions.assertThat((Iterable)this.fs.inputFiles(this.fs.predicates().all())).isEmpty();
        this.fs.add((InputFile)new TestInputFileBuilder("foo", "src/Foo.php").setLanguage("php").build());
        this.fs.add((InputFile)new TestInputFileBuilder("foo", "src/Bar.java").setLanguage("java").build());
        this.fs.add((InputFile)new TestInputFileBuilder("foo", "src/Baz.java").setLanguage("java").build());
        this.fs.add((InputFile)new TestInputFileBuilder("foo", "src/readme.txt").build());
        Assertions.assertThat((Object)this.fs.inputFile(this.fs.predicates().hasRelativePath("src/Bar.java"))).isNotNull();
        Assertions.assertThat((Object)this.fs.inputFile(this.fs.predicates().hasRelativePath("does/not/exist"))).isNull();
        Assertions.assertThat((Iterable)this.fs.files(this.fs.predicates().all())).hasSize(4);
        Assertions.assertThat((Iterable)this.fs.files(this.fs.predicates().hasLanguage("java"))).hasSize(2);
        Assertions.assertThat((Iterable)this.fs.files(this.fs.predicates().hasLanguage("cobol"))).isEmpty();
        Assertions.assertThat((boolean)this.fs.hasFiles(this.fs.predicates().all())).isTrue();
        Assertions.assertThat((boolean)this.fs.hasFiles(this.fs.predicates().hasLanguage("java"))).isTrue();
        Assertions.assertThat((boolean)this.fs.hasFiles(this.fs.predicates().hasLanguage("cobol"))).isFalse();
        Assertions.assertThat((Iterable)this.fs.inputFiles(this.fs.predicates().all())).hasSize(4);
        Assertions.assertThat((Iterable)this.fs.inputFiles(this.fs.predicates().hasLanguage("php"))).hasSize(1);
        Assertions.assertThat((Iterable)this.fs.inputFiles(this.fs.predicates().hasLanguage("java"))).hasSize(2);
        Assertions.assertThat((Iterable)this.fs.inputFiles(this.fs.predicates().hasLanguage("cobol"))).isEmpty();
        Assertions.assertThat((Iterable)this.fs.languages()).containsOnly((Object[])new String[]{"java", "php"});
    }

    @Test
    public void filesWithDefaultPredicate() {
        DefaultInputFile file1 = new TestInputFileBuilder("foo", "src/Foo.php").setLanguage("php").build();
        this.fs.add((InputFile)file1);
        this.fs.add((InputFile)new TestInputFileBuilder("foo", "src/Bar.java").setLanguage("java").build());
        this.fs.add((InputFile)new TestInputFileBuilder("foo", "src/Baz.java").setLanguage("java").build());
        this.fs.setDefaultPredicate(f -> f.relativePath().endsWith("Foo.php"));
        Iterator iterator = this.fs.files(this.fs.predicates().all()).iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((File)((File)iterator.next())).isEqualTo((Object)file1.file());
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    @Test
    public void input_file_returns_null_if_file_not_found() {
        Assertions.assertThat((Object)this.fs.inputFile(this.fs.predicates().hasRelativePath("src/Bar.java"))).isNull();
        Assertions.assertThat((Object)this.fs.inputFile(this.fs.predicates().hasLanguage("cobol"))).isNull();
    }

    @Test
    public void input_file_fails_if_too_many_results() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("expected one element");
        this.fs.add((InputFile)new TestInputFileBuilder("foo", "src/Bar.java").setLanguage("java").build());
        this.fs.add((InputFile)new TestInputFileBuilder("foo", "src/Baz.java").setLanguage("java").build());
        this.fs.inputFile(this.fs.predicates().all());
    }

    @Test
    public void input_file_supports_non_indexed_predicates() {
        this.fs.add((InputFile)new TestInputFileBuilder("foo", "src/Bar.java").setLanguage("java").build());
        Assertions.assertThat((Object)this.fs.inputFile(this.fs.predicates().hasLanguage("java"))).isNotNull();
    }
}

