/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFilePredicates;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;

public class DefaultFilePredicatesTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private Path moduleBasePath;
    InputFile javaFile;
    FilePredicates predicates;

    @Before
    public void setUp() throws IOException {
        this.moduleBasePath = this.temp.newFolder().toPath();
    }

    @Before
    public void before() throws IOException {
        this.predicates = new DefaultFilePredicates(this.temp.newFolder().toPath());
        this.javaFile = new TestInputFileBuilder("foo", "src/main/java/struts/Action.java").setModuleBaseDir(this.moduleBasePath).setLanguage("java").build();
    }

    @Test
    public void all() {
        Assertions.assertThat((boolean)this.predicates.all().apply(this.javaFile)).isTrue();
    }

    @Test
    public void none() {
        Assertions.assertThat((boolean)this.predicates.none().apply(this.javaFile)).isFalse();
    }

    @Test
    public void matches_inclusion_pattern() {
        Assertions.assertThat((boolean)this.predicates.matchesPathPattern("src/main/**/Action.java").apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.matchesPathPattern("Action.java").apply(this.javaFile)).isFalse();
        Assertions.assertThat((boolean)this.predicates.matchesPathPattern("src/**/*.php").apply(this.javaFile)).isFalse();
    }

    @Test
    public void matches_inclusion_patterns() {
        Assertions.assertThat((boolean)this.predicates.matchesPathPatterns(new String[]{"src/other/**.java", "src/main/**/Action.java"}).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.matchesPathPatterns(new String[0]).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.matchesPathPatterns(new String[]{"src/other/**.java", "src/**/*.php"}).apply(this.javaFile)).isFalse();
    }

    @Test
    public void does_not_match_exclusion_pattern() {
        Assertions.assertThat((boolean)this.predicates.doesNotMatchPathPattern("src/main/**/Action.java").apply(this.javaFile)).isFalse();
        Assertions.assertThat((boolean)this.predicates.doesNotMatchPathPattern("Action.java").apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.doesNotMatchPathPattern("src/**/*.php").apply(this.javaFile)).isTrue();
    }

    @Test
    public void does_not_match_exclusion_patterns() {
        Assertions.assertThat((boolean)this.predicates.doesNotMatchPathPatterns(new String[0]).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.doesNotMatchPathPatterns(new String[]{"src/other/**.java", "src/**/*.php"}).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.doesNotMatchPathPatterns(new String[]{"src/other/**.java", "src/main/**/Action.java"}).apply(this.javaFile)).isFalse();
    }

    @Test
    public void has_relative_path() {
        Assertions.assertThat((boolean)this.predicates.hasRelativePath("src/main/java/struts/Action.java").apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.hasRelativePath("src/main/java/struts/Other.java").apply(this.javaFile)).isFalse();
        Assertions.assertThat((boolean)this.predicates.hasRelativePath("src/main/java/../java/struts/Action.java").apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.hasRelativePath("src\\main\\java\\struts\\Action.java").apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.hasRelativePath("src\\main\\java\\struts\\Other.java").apply(this.javaFile)).isFalse();
        Assertions.assertThat((boolean)this.predicates.hasRelativePath("src\\main\\java\\struts\\..\\struts\\Action.java").apply(this.javaFile)).isTrue();
    }

    @Test
    public void has_absolute_path() throws Exception {
        String path = this.javaFile.file().getAbsolutePath();
        Assertions.assertThat((boolean)this.predicates.hasAbsolutePath(path).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.hasAbsolutePath(path.replaceAll("/", "\\\\")).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.hasAbsolutePath(this.temp.newFile().getAbsolutePath()).apply(this.javaFile)).isFalse();
        Assertions.assertThat((boolean)this.predicates.hasAbsolutePath("src/main/java/struts/Action.java").apply(this.javaFile)).isFalse();
    }

    @Test
    public void has_path() throws Exception {
        Assertions.assertThat((boolean)this.predicates.hasPath("src/main/java/struts/Action.java").apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.hasPath("src/main/java/struts/Other.java").apply(this.javaFile)).isFalse();
        String path = this.javaFile.file().getAbsolutePath();
        Assertions.assertThat((boolean)this.predicates.hasAbsolutePath(path).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.hasPath(this.temp.newFile().getAbsolutePath()).apply(this.javaFile)).isFalse();
    }

    @Test
    public void is_file() throws Exception {
        Assertions.assertThat((boolean)this.predicates.is(new File(this.javaFile.relativePath())).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.is(this.javaFile.file()).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.is(this.javaFile.file().getAbsoluteFile()).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.is(this.javaFile.file().getCanonicalFile()).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.is(new File(this.javaFile.file().toURI())).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.is(this.temp.newFile()).apply(this.javaFile)).isFalse();
    }

    @Test
    public void has_language() {
        Assertions.assertThat((boolean)this.predicates.hasLanguage("java").apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.hasLanguage("php").apply(this.javaFile)).isFalse();
    }

    @Test
    public void has_languages() {
        Assertions.assertThat((boolean)this.predicates.hasLanguages(Arrays.asList("java", "php")).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.hasLanguages(Arrays.asList("cobol", "php")).apply(this.javaFile)).isFalse();
        Assertions.assertThat((boolean)this.predicates.hasLanguages(Collections.emptyList()).apply(this.javaFile)).isTrue();
    }

    @Test
    public void has_type() {
        Assertions.assertThat((boolean)this.predicates.hasType(InputFile.Type.MAIN).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.hasType(InputFile.Type.TEST).apply(this.javaFile)).isFalse();
    }

    @Test
    public void not() {
        Assertions.assertThat((boolean)this.predicates.not(this.predicates.hasType(InputFile.Type.MAIN)).apply(this.javaFile)).isFalse();
        Assertions.assertThat((boolean)this.predicates.not(this.predicates.hasType(InputFile.Type.TEST)).apply(this.javaFile)).isTrue();
    }

    @Test
    public void and() {
        Assertions.assertThat((boolean)this.predicates.and(new FilePredicate[0]).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.and(new FilePredicate[0]).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.and(Collections.emptyList()).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.and(this.predicates.all(), this.predicates.all()).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.and(this.predicates.all(), this.predicates.none()).apply(this.javaFile)).isFalse();
        Assertions.assertThat((boolean)this.predicates.and(this.predicates.none(), this.predicates.all()).apply(this.javaFile)).isFalse();
        Assertions.assertThat((boolean)this.predicates.and(Arrays.asList(this.predicates.all(), this.predicates.all())).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.and(Arrays.asList(this.predicates.all(), this.predicates.none())).apply(this.javaFile)).isFalse();
        Assertions.assertThat((boolean)this.predicates.and(new FilePredicate[]{this.predicates.all(), this.predicates.all()}).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.and(new FilePredicate[]{this.predicates.all(), this.predicates.none()}).apply(this.javaFile)).isFalse();
    }

    @Test
    public void or() {
        Assertions.assertThat((boolean)this.predicates.or(new FilePredicate[0]).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.or(new FilePredicate[0]).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.or(Collections.emptyList()).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.or(this.predicates.all(), this.predicates.all()).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.or(this.predicates.all(), this.predicates.none()).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.or(this.predicates.none(), this.predicates.all()).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.or(this.predicates.none(), this.predicates.none()).apply(this.javaFile)).isFalse();
        Assertions.assertThat((boolean)this.predicates.or(Arrays.asList(this.predicates.all(), this.predicates.all())).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.or(Arrays.asList(this.predicates.all(), this.predicates.none())).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.or(Arrays.asList(this.predicates.none(), this.predicates.none())).apply(this.javaFile)).isFalse();
        Assertions.assertThat((boolean)this.predicates.or(new FilePredicate[]{this.predicates.all(), this.predicates.all()}).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.or(new FilePredicate[]{this.predicates.all(), this.predicates.none()}).apply(this.javaFile)).isTrue();
        Assertions.assertThat((boolean)this.predicates.or(new FilePredicate[]{this.predicates.none(), this.predicates.none()}).apply(this.javaFile)).isFalse();
    }

    @Test
    public void hasFilename() {
        Assertions.assertThat((boolean)this.predicates.hasFilename("Action.java").apply(this.javaFile)).isTrue();
    }

    @Test
    public void hasExtension() {
        Assertions.assertThat((boolean)this.predicates.hasExtension("java").apply(this.javaFile)).isTrue();
    }
}

