/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.internal.AndPredicate;
import org.sonar.api.batch.fs.internal.FalsePredicate;
import org.sonar.api.batch.fs.internal.OptimizedFilePredicate;
import org.sonar.api.batch.fs.internal.PathPattern;
import org.sonar.api.batch.fs.internal.PathPatternPredicate;
import org.sonar.api.batch.fs.internal.RelativePathPredicate;
import org.sonar.api.batch.fs.internal.TruePredicate;

public class AndPredicateTest {
    @Test
    public void flattenNestedAnd() {
        PathPatternPredicate pathPatternPredicate1 = new PathPatternPredicate(PathPattern.create((String)"foo1/**"));
        PathPatternPredicate pathPatternPredicate2 = new PathPatternPredicate(PathPattern.create((String)"foo2/**"));
        PathPatternPredicate pathPatternPredicate3 = new PathPatternPredicate(PathPattern.create((String)"foo3/**"));
        FilePredicate andPredicate = AndPredicate.create(Arrays.asList(pathPatternPredicate1, AndPredicate.create(Arrays.asList(pathPatternPredicate2, pathPatternPredicate3))));
        Assertions.assertThat((Iterable)((AndPredicate)andPredicate).predicates()).containsExactly((Object[])new OptimizedFilePredicate[]{pathPatternPredicate1, pathPatternPredicate2, pathPatternPredicate3});
    }

    @Test
    public void sortPredicatesByPriority() {
        PathPatternPredicate pathPatternPredicate1 = new PathPatternPredicate(PathPattern.create((String)"foo1/**"));
        PathPatternPredicate pathPatternPredicate2 = new PathPatternPredicate(PathPattern.create((String)"foo2/**"));
        RelativePathPredicate relativePathPredicate = new RelativePathPredicate("foo");
        FilePredicate andPredicate = AndPredicate.create(Arrays.asList(pathPatternPredicate1, relativePathPredicate, pathPatternPredicate2));
        Assertions.assertThat((Iterable)((AndPredicate)andPredicate).predicates()).containsExactly((Object[])new OptimizedFilePredicate[]{relativePathPredicate, pathPatternPredicate1, pathPatternPredicate2});
    }

    @Test
    public void simplifyAndExpressionsWhenEmpty() {
        FilePredicate andPredicate = AndPredicate.create(Arrays.asList(new FilePredicate[0]));
        Assertions.assertThat((Object)andPredicate).isEqualTo((Object)TruePredicate.TRUE);
    }

    @Test
    public void simplifyAndExpressionsWhenTrue() {
        PathPatternPredicate pathPatternPredicate1 = new PathPatternPredicate(PathPattern.create((String)"foo1/**"));
        PathPatternPredicate pathPatternPredicate2 = new PathPatternPredicate(PathPattern.create((String)"foo2/**"));
        FilePredicate andPredicate = AndPredicate.create(Arrays.asList(pathPatternPredicate1, TruePredicate.TRUE, pathPatternPredicate2));
        Assertions.assertThat((Iterable)((AndPredicate)andPredicate).predicates()).containsExactly((Object[])new OptimizedFilePredicate[]{pathPatternPredicate1, pathPatternPredicate2});
    }

    @Test
    public void simplifyAndExpressionsWhenFalse() {
        PathPatternPredicate pathPatternPredicate1 = new PathPatternPredicate(PathPattern.create((String)"foo1/**"));
        PathPatternPredicate pathPatternPredicate2 = new PathPatternPredicate(PathPattern.create((String)"foo2/**"));
        FilePredicate andPredicate = AndPredicate.create(Arrays.asList(pathPatternPredicate1, FalsePredicate.FALSE, pathPatternPredicate2));
        Assertions.assertThat((Object)andPredicate).isEqualTo((Object)FalsePredicate.FALSE);
    }
}

