/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.debt;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.batch.debt.DebtRemediationFunction;
import org.sonar.api.utils.Duration;

public class DebtRemediationFunctionTest {
    @Test
    public void create_linear() {
        DebtRemediationFunction function = DebtRemediationFunction.createLinear((Duration)Duration.create((long)10L));
        Assertions.assertThat((Comparable)function.type()).isEqualTo((Object)DebtRemediationFunction.Type.LINEAR);
        Assertions.assertThat((Object)function.coefficient()).isEqualTo((Object)Duration.create((long)10L));
        Assertions.assertThat((Object)function.offset()).isNull();
    }

    @Test
    public void create_linear_with_offset() {
        DebtRemediationFunction function = DebtRemediationFunction.createLinearWithOffset((Duration)Duration.create((long)10L), (Duration)Duration.create((long)5L));
        Assertions.assertThat((Comparable)function.type()).isEqualTo((Object)DebtRemediationFunction.Type.LINEAR_OFFSET);
        Assertions.assertThat((Object)function.coefficient()).isEqualTo((Object)Duration.create((long)10L));
        Assertions.assertThat((Object)function.offset()).isEqualTo((Object)Duration.create((long)5L));
    }

    @Test
    public void create_constant_per_issue() {
        DebtRemediationFunction function = DebtRemediationFunction.createConstantPerIssue((Duration)Duration.create((long)10L));
        Assertions.assertThat((Comparable)function.type()).isEqualTo((Object)DebtRemediationFunction.Type.CONSTANT_ISSUE);
        Assertions.assertThat((Object)function.coefficient()).isNull();
        Assertions.assertThat((Object)function.offset()).isEqualTo((Object)Duration.create((long)10L));
    }

    @Test
    public void test_equals_and_hashcode() throws Exception {
        DebtRemediationFunction function = DebtRemediationFunction.createLinearWithOffset((Duration)Duration.create((long)10L), (Duration)Duration.create((long)5L));
        DebtRemediationFunction functionWithSameValue = DebtRemediationFunction.createLinearWithOffset((Duration)Duration.create((long)10L), (Duration)Duration.create((long)5L));
        DebtRemediationFunction functionWithDifferentType = DebtRemediationFunction.createConstantPerIssue((Duration)Duration.create((long)5L));
        Assertions.assertThat((Object)function).isEqualTo((Object)function);
        Assertions.assertThat((Object)function).isEqualTo((Object)functionWithSameValue);
        Assertions.assertThat((Object)function).isNotEqualTo((Object)functionWithDifferentType);
        Assertions.assertThat((Object)function).isNotEqualTo((Object)DebtRemediationFunction.createLinearWithOffset((Duration)Duration.create((long)11L), (Duration)Duration.create((long)5L)));
        Assertions.assertThat((Object)function).isNotEqualTo((Object)DebtRemediationFunction.createLinearWithOffset((Duration)Duration.create((long)10L), (Duration)Duration.create((long)6L)));
        Assertions.assertThat((Object)function).isNotEqualTo((Object)DebtRemediationFunction.createLinear((Duration)Duration.create((long)10L)));
        Assertions.assertThat((Object)function).isNotEqualTo((Object)DebtRemediationFunction.createConstantPerIssue((Duration)Duration.create((long)6L)));
        Assertions.assertThat((int)function.hashCode()).isEqualTo(function.hashCode());
        Assertions.assertThat((int)function.hashCode()).isEqualTo(functionWithSameValue.hashCode());
        Assertions.assertThat((int)function.hashCode()).isNotEqualTo(functionWithDifferentType.hashCode());
    }

    @Test
    public void test_to_string() throws Exception {
        Assertions.assertThat((String)DebtRemediationFunction.createLinearWithOffset((Duration)Duration.create((long)10L), (Duration)Duration.create((long)5L)).toString()).isNotNull();
    }
}

