/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.bootstrap;

import java.util.List;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.batch.bootstrap.ProjectDefinition;

public class ProjectDefinitionTest {
    @Test
    public void shouldSetKey() {
        ProjectDefinition def = ProjectDefinition.create();
        def.setKey("mykey");
        Assertions.assertThat((String)def.getKey()).isEqualTo((Object)"mykey");
    }

    @Test
    public void shouldSetVersion() {
        ProjectDefinition def = ProjectDefinition.create();
        def.setVersion("2.0-SNAPSHOT");
        Assertions.assertThat((String)def.getVersion()).isEqualTo((Object)"2.0-SNAPSHOT");
    }

    @Test
    public void shouldSupportNoVersion() {
        ProjectDefinition def = ProjectDefinition.create();
        def.setVersion(null);
        Assertions.assertThat((String)def.getVersion()).isEqualTo((Object)"not provided");
        Assertions.assertThat((String)def.getOriginalVersion()).isEqualTo((Object)"");
    }

    @Test
    public void shouldSetOptionalFields() {
        ProjectDefinition def = ProjectDefinition.create();
        def.setName("myname");
        def.setDescription("desc");
        Assertions.assertThat((String)def.getName()).isEqualTo((Object)"myname");
        Assertions.assertThat((String)def.getDescription()).isEqualTo((Object)"desc");
    }

    @Test
    public void shouldSupportDefaultName() {
        ProjectDefinition def = ProjectDefinition.create();
        def.setKey("myKey");
        Assertions.assertThat((String)def.getName()).isEqualTo((Object)"myKey");
    }

    @Test
    public void shouldGetKeyFromProperties() {
        Properties props = new Properties();
        props.setProperty("sonar.projectKey", "foo");
        ProjectDefinition def = ProjectDefinition.create();
        def.setProperties(props);
        Assertions.assertThat((String)def.getKey()).isEqualTo((Object)"foo");
    }

    @Test
    public void testDefaultValues() {
        ProjectDefinition def = ProjectDefinition.create();
        Assertions.assertThat((List)def.sources()).isEmpty();
        Assertions.assertThat((List)def.tests()).isEmpty();
    }

    @Test
    public void shouldTrimPaths() {
        ProjectDefinition def = ProjectDefinition.create();
        def.setSources(new String[]{"src1", " src2 ", " with whitespace"});
        def.setTests(new String[]{"test1", " test2 ", " with whitespace"});
        Assertions.assertThat((List)def.sources()).containsOnly((Object[])new String[]{"src1", "src2", "with whitespace"});
        Assertions.assertThat((List)def.tests()).containsOnly((Object[])new String[]{"test1", "test2", "with whitespace"});
    }

    @Test
    public void shouldManageRelationships() {
        ProjectDefinition root = ProjectDefinition.create();
        ProjectDefinition child = ProjectDefinition.create();
        root.addSubProject(child);
        Assertions.assertThat((List)root.getSubProjects()).hasSize(1);
        Assertions.assertThat((List)child.getSubProjects()).isEmpty();
        Assertions.assertThat((Object)root.getParent()).isNull();
        Assertions.assertThat((Object)child.getParent()).isEqualTo((Object)root);
    }

    @Test
    public void shouldResetSourceDirs() {
        ProjectDefinition root = ProjectDefinition.create();
        root.addSources(new String[]{"src", "src2/main"});
        Assertions.assertThat((List)root.sources()).hasSize(2);
        root.resetSources();
        Assertions.assertThat((List)root.sources()).isEmpty();
    }

    @Test
    public void shouldResetTestDirs() {
        ProjectDefinition root = ProjectDefinition.create();
        root.addTests(new String[]{"src", "src2/test"});
        Assertions.assertThat((List)root.tests()).hasSize(2);
        root.resetTests();
        Assertions.assertThat((List)root.tests()).isEmpty();
    }
}

