/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.bootstrap;

import java.io.File;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.batch.bootstrap.ProjectBuilder;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.batch.bootstrap.internal.ProjectBuilderContext;
import org.sonar.api.config.MapSettings;
import org.sonar.api.config.Settings;

public class ProjectBuilderTest {
    @Test
    public void shouldChangeProject() {
        ProjectReactor projectReactor = new ProjectReactor(ProjectDefinition.create());
        ProjectBuilderSample builder = new ProjectBuilderSample((Settings)new MapSettings());
        builder.build((ProjectBuilder.Context)new ProjectBuilderContext(projectReactor));
        Assert.assertThat((Object)projectReactor.getProjects().size(), (Matcher)Is.is((Object)2));
        ProjectDefinition root = projectReactor.getRoot();
        Assert.assertThat((Object)root.getName(), (Matcher)Is.is((Object)"Name changed by plugin"));
        Assert.assertThat((Object)root.getSubProjects().size(), (Matcher)Is.is((Object)1));
        Assertions.assertThat((List)((ProjectDefinition)root.getSubProjects().get(0)).sources()).contains((Object[])new String[]{"src"});
    }

    static final class ProjectBuilderSample
    extends ProjectBuilder {
        private Settings conf;

        public ProjectBuilderSample(Settings conf) {
            this.conf = conf;
        }

        protected void build(ProjectReactor reactor) {
            ProjectDefinition root = reactor.getRoot();
            root.setName("Name changed by plugin");
            File baseDir = new File(root.getBaseDir(), "path/to/subproject");
            ProjectDefinition subProject = ProjectDefinition.create();
            subProject.setBaseDir(baseDir);
            subProject.setWorkDir(new File(baseDir, "target/.sonar"));
            subProject.setKey("groupId:parentProjectId");
            subProject.setVersion(root.getOriginalVersion());
            subProject.setName("Sub Project");
            subProject.setSources(new String[]{"src"});
            root.addSubProject(subProject);
        }
    }
}

