/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.sonar.api.batch.AbstractSumChildrenDecorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.test.IsMeasure;

public class AbstractSumChildrenDecoratorTest {
    @Test
    public void sumChildren() {
        DecoratorContext context = (DecoratorContext)Mockito.mock(DecoratorContext.class);
        Mockito.when((Object)context.getChildrenMeasures(CoreMetrics.LINES)).thenReturn(Arrays.asList(new Measure(CoreMetrics.LINES, Double.valueOf(100.0)), new Measure(CoreMetrics.LINES, Double.valueOf(50.0))));
        this.create(false).decorate(null, context);
        ((DecoratorContext)Mockito.verify((Object)context)).saveMeasure((Measure)Matchers.argThat((Matcher)new IsMeasure(CoreMetrics.LINES, 150.0)));
    }

    @Test
    public void doNotSaveZeroIfNoChildren() {
        DecoratorContext context = (DecoratorContext)Mockito.mock(DecoratorContext.class);
        Mockito.when((Object)context.getChildrenMeasures(CoreMetrics.LINES)).thenReturn(Arrays.asList(new Measure[0]));
        this.create(false).decorate(null, context);
        ((DecoratorContext)Mockito.verify((Object)context, (VerificationMode)Mockito.never())).saveMeasure((Measure)Matchers.any(Measure.class));
    }

    @Test
    public void saveZeroIfNoChildren() {
        DecoratorContext context = (DecoratorContext)Mockito.mock(DecoratorContext.class);
        Mockito.when((Object)context.getChildrenMeasures(CoreMetrics.LINES)).thenReturn(Arrays.asList(new Measure[0]));
        this.create(true).decorate(null, context);
        ((DecoratorContext)Mockito.verify((Object)context)).saveMeasure((Measure)Matchers.argThat((Matcher)new IsMeasure(CoreMetrics.LINES, 0.0)));
    }

    private AbstractSumChildrenDecorator create(final boolean zeroIfNoChildMeasures) {
        return new AbstractSumChildrenDecorator(){

            @DependedUpon
            public List<Metric> generatesMetrics() {
                return Arrays.asList(CoreMetrics.LINES);
            }

            protected boolean shouldSaveZeroIfNoChildMeasures() {
                return zeroIfNoChildMeasures;
            }
        };
    }
}

