/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.Plugin;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.SonarRuntime;
import org.sonar.api.internal.SonarRuntimeImpl;
import org.sonar.api.utils.Version;

public class PluginTest {
    private static final Version VERSION_5_6 = Version.create((int)5, (int)6);

    @Test
    public void test_context() {
        SonarRuntime runtime = SonarRuntimeImpl.forSonarQube((Version)VERSION_5_6, (SonarQubeSide)SonarQubeSide.SERVER);
        Plugin.Context context = new Plugin.Context(runtime);
        Assertions.assertThat((Comparable)context.getSonarQubeVersion()).isEqualTo((Object)VERSION_5_6);
        Assertions.assertThat((List)context.getExtensions()).isEmpty();
        context.addExtension((Object)"foo");
        Assertions.assertThat((List)context.getExtensions()).containsOnly(new Object[]{"foo"});
        context.addExtensions(Arrays.asList("bar", "baz"));
        Assertions.assertThat((List)context.getExtensions()).containsOnly(new Object[]{"foo", "bar", "baz"});
        context.addExtensions((Object)"one", (Object)"two", new Object[]{"three", "four"});
        Assertions.assertThat((List)context.getExtensions()).containsOnly(new Object[]{"foo", "bar", "baz", "one", "two", "three", "four"});
    }
}

