/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc.util;

import java.util.Comparator;
import java.util.function.Function;
import org.shredzone.commons.suncalc.util.JulianDate;
import org.shredzone.commons.suncalc.util.Matrix;
import org.shredzone.commons.suncalc.util.Vector;

public final class ExtendedMath {
    public static final double PI2 = Math.PI * 2;
    public static final double ARCS = Math.toDegrees(3600.0);
    public static final double EARTH_MEAN_RADIUS = 6371.0;
    public static final double REFRACTION_AT_HORIZON = Math.PI / (Math.tan(Math.toRadians(1.6613636363636362)) * 10800.0);

    private ExtendedMath() {
    }

    public static double frac(double a) {
        return a % 1.0;
    }

    public static boolean isZero(double d) {
        return !Double.isNaN(d) && Math.round(Math.signum(d)) == 0L;
    }

    public static Vector equatorialToHorizontal(double tau, double dec, double dist, double lat) {
        return Matrix.rotateY(1.5707963267948966 - lat).multiply(Vector.ofPolar(tau, dec, dist));
    }

    public static Matrix equatorialToEcliptical(JulianDate t) {
        double jc = t.getJulianCentury();
        double eps = Math.toRadians(23.43929111 - (46.815 + (5.9E-4 - 0.001813 * jc) * jc) * jc / 3600.0);
        return Matrix.rotateX(eps);
    }

    public static double parallax(double elevation, double distance) {
        return Math.asin(6371.0 / distance) - Math.acos(6371.0 / (6371.0 + elevation / 1000.0));
    }

    public static double apparentRefraction(double ha) {
        if (ha < 0.0) {
            return 0.0;
        }
        if (ExtendedMath.isZero(ha)) {
            return REFRACTION_AT_HORIZON;
        }
        return Math.PI / (Math.tan(Math.toRadians(ha + 7.31 / (ha + 4.4))) * 10800.0);
    }

    public static double refraction(double h) {
        if (h < 0.0) {
            return 0.0;
        }
        return 2.96706E-4 / Math.tan(h + 0.00312537 / (h + 0.0890118));
    }

    public static double dms(int d, int m, double s) {
        double sig = d < 0 ? -1.0 : 1.0;
        return sig * ((Math.abs(s) / 60.0 + (double)Math.abs(m)) / 60.0 + (double)Math.abs(d));
    }

    public static double readjustMax(double time, double frame, int depth, Function<Double, Double> f) {
        double left = time - frame;
        double right = time + frame;
        double leftY = f.apply(left);
        double rightY = f.apply(right);
        return ExtendedMath.readjustInterval(left, right, leftY, rightY, depth, f, Double::compare);
    }

    public static double readjustMin(double time, double frame, int depth, Function<Double, Double> f) {
        double left = time - frame;
        double right = time + frame;
        double leftY = f.apply(left);
        double rightY = f.apply(right);
        return ExtendedMath.readjustInterval(left, right, leftY, rightY, depth, f, (yl, yr) -> Double.compare(yr, yl));
    }

    private static double readjustInterval(double left, double right, double yl, double yr, int depth, Function<Double, Double> f, Comparator<Double> cmp) {
        if (depth <= 0) {
            return cmp.compare(yl, yr) < 0 ? right : left;
        }
        double middle = (left + right) / 2.0;
        double ym = f.apply(middle);
        if (cmp.compare(yl, yr) < 0) {
            return ExtendedMath.readjustInterval(middle, right, ym, yr, depth - 1, f, cmp);
        }
        return ExtendedMath.readjustInterval(left, middle, yl, ym, depth - 1, f, cmp);
    }
}

