/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc.util;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.shredzone.commons.suncalc.param.GenericParameter;
import org.shredzone.commons.suncalc.param.LocationParameter;
import org.shredzone.commons.suncalc.param.TimeParameter;
import org.shredzone.commons.suncalc.param.WindowParameter;
import org.shredzone.commons.suncalc.util.JulianDate;

public class BaseBuilder<T>
implements GenericParameter<T>,
LocationParameter<T>,
TimeParameter<T>,
WindowParameter<T>,
Cloneable {
    @Nullable
    private Double lat = null;
    @Nullable
    private Double lng = null;
    private double elevation = 0.0;
    private ZonedDateTime dateTime = ZonedDateTime.now();
    private boolean reverse = false;
    private Duration duration = Duration.ofDays(365L);

    @Override
    public T on(ZonedDateTime dateTime) {
        this.dateTime = Objects.requireNonNull(dateTime, "dateTime");
        return (T)this;
    }

    @Override
    public T on(LocalDateTime dateTime) {
        Objects.requireNonNull(dateTime, "dateTime");
        return this.on(ZonedDateTime.of(dateTime, this.dateTime.getZone()));
    }

    @Override
    public T on(LocalDate date) {
        Objects.requireNonNull(date, "date");
        return this.on(ZonedDateTime.of(date, LocalTime.MIDNIGHT, this.dateTime.getZone()));
    }

    @Override
    public T on(Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return this.on(ZonedDateTime.ofInstant(instant, this.dateTime.getZone()));
    }

    @Override
    public T on(int year, int month, int date, int hour, int minute, int second) {
        return this.on(ZonedDateTime.of(year, month, date, hour, minute, second, 0, this.dateTime.getZone()));
    }

    @Override
    public T now() {
        return this.on(ZonedDateTime.now(this.dateTime.getZone()));
    }

    @Override
    public T plusDays(int days) {
        return this.on(this.dateTime.plusDays(days));
    }

    @Override
    public T midnight() {
        return this.on(this.dateTime.truncatedTo(ChronoUnit.DAYS));
    }

    @Override
    public T timezone(ZoneId tz) {
        Objects.requireNonNull(tz, "tz");
        this.on(this.dateTime.withZoneSameLocal(tz));
        return (T)this;
    }

    @Override
    public T latitude(double lat) {
        if (lat < -90.0 || lat > 90.0) {
            throw new IllegalArgumentException("Latitude out of range, -90.0 <= " + lat + " <= 90.0");
        }
        this.lat = lat;
        return (T)this;
    }

    @Override
    public T longitude(double lng) {
        if (lng < -180.0 || lng > 180.0) {
            throw new IllegalArgumentException("Longitude out of range, -180.0 <= " + lng + " <= 180.0");
        }
        this.lng = lng;
        return (T)this;
    }

    @Override
    public T elevation(double h) {
        this.elevation = Math.max(h, 0.0);
        return (T)this;
    }

    @Override
    public T limit(Duration duration) {
        Objects.requireNonNull(duration, "duration");
        this.duration = duration;
        if (duration.isNegative()) {
            this.reverse();
        }
        return (T)this;
    }

    @Override
    public T reverse() {
        this.reverse = true;
        return (T)this;
    }

    @Override
    public T forward() {
        this.reverse = false;
        return (T)this;
    }

    @Override
    public T sameTimeAs(TimeParameter<?> t) {
        if (!(t instanceof BaseBuilder)) {
            throw new IllegalArgumentException("Cannot read the TimeParameter");
        }
        this.dateTime = ((BaseBuilder)t).dateTime;
        return (T)this;
    }

    @Override
    public T sameLocationAs(LocationParameter<?> l) {
        if (!(l instanceof BaseBuilder)) {
            throw new IllegalArgumentException("Cannot read the LocationParameter");
        }
        BaseBuilder origin = (BaseBuilder)l;
        this.lat = origin.lat;
        this.lng = origin.lng;
        this.elevation = origin.elevation;
        return (T)this;
    }

    @Override
    public T sameWindowAs(WindowParameter<?> w) {
        if (!(w instanceof BaseBuilder)) {
            throw new IllegalArgumentException("Cannot read the WindowParameter");
        }
        BaseBuilder origin = (BaseBuilder)w;
        this.duration = origin.duration;
        this.reverse = origin.reverse;
        return (T)this;
    }

    @Override
    public T copy() {
        try {
            return (T)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public double getLongitude() {
        if (this.lng == null) {
            throw new IllegalStateException("longitude is not set");
        }
        return this.lng;
    }

    public double getLatitude() {
        if (this.lat == null) {
            throw new IllegalStateException("latitude is not set");
        }
        return this.lat;
    }

    public double getLongitudeRad() {
        return Math.toRadians(this.getLongitude());
    }

    public double getLatitudeRad() {
        return Math.toRadians(this.getLatitude());
    }

    public double getElevation() {
        return this.elevation;
    }

    public JulianDate getJulianDate() {
        return new JulianDate(this.dateTime);
    }

    public boolean hasLocation() {
        return this.lat != null && this.lng != null;
    }

    public void clearLocation() {
        this.lat = null;
        this.lng = null;
    }

    public Duration getDuration() {
        if (this.reverse != this.duration.isNegative()) {
            return this.duration.negated();
        }
        return this.duration;
    }
}

