/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc.param;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

public interface TimeParameter<T> {
    public T on(int var1, int var2, int var3, int var4, int var5, int var6);

    default public T on(int year, int month, int date) {
        return this.on(year, month, date, 0, 0, 0);
    }

    public T on(ZonedDateTime var1);

    public T on(LocalDateTime var1);

    public T on(LocalDate var1);

    public T on(Instant var1);

    default public T on(Date date) {
        Objects.requireNonNull(date, "date");
        return this.on(date.toInstant());
    }

    default public T on(Calendar cal) {
        Objects.requireNonNull(cal, "cal");
        return this.on(ZonedDateTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId()));
    }

    public T now();

    public T midnight();

    public T plusDays(int var1);

    default public T today() {
        this.now();
        this.midnight();
        return (T)this;
    }

    default public T tomorrow() {
        this.today();
        this.plusDays(1);
        return (T)this;
    }

    public T timezone(ZoneId var1);

    default public T timezone(String id) {
        return this.timezone(ZoneId.of(id));
    }

    default public T localTime() {
        return this.timezone(ZoneId.systemDefault());
    }

    default public T utc() {
        return this.timezone("UTC");
    }

    default public T timezone(TimeZone tz) {
        Objects.requireNonNull(tz, "tz");
        return this.timezone(tz.toZoneId());
    }

    public T sameTimeAs(TimeParameter<?> var1);
}

