/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.ZonedDateTime;
import org.shredzone.commons.suncalc.param.Builder;
import org.shredzone.commons.suncalc.param.GenericParameter;
import org.shredzone.commons.suncalc.param.LocationParameter;
import org.shredzone.commons.suncalc.param.TimeParameter;
import org.shredzone.commons.suncalc.param.WindowParameter;
import org.shredzone.commons.suncalc.util.BaseBuilder;
import org.shredzone.commons.suncalc.util.ExtendedMath;
import org.shredzone.commons.suncalc.util.JulianDate;
import org.shredzone.commons.suncalc.util.Moon;
import org.shredzone.commons.suncalc.util.QuadraticInterpolation;
import org.shredzone.commons.suncalc.util.Vector;

public final class MoonTimes {
    @Nullable
    private final ZonedDateTime rise;
    @Nullable
    private final ZonedDateTime set;
    private final boolean alwaysUp;
    private final boolean alwaysDown;

    private MoonTimes(@Nullable ZonedDateTime rise, @Nullable ZonedDateTime set, boolean alwaysUp, boolean alwaysDown) {
        this.rise = rise;
        this.set = set;
        this.alwaysUp = alwaysUp;
        this.alwaysDown = alwaysDown;
    }

    public static Parameters compute() {
        return new MoonTimesBuilder();
    }

    @Nullable
    public ZonedDateTime getRise() {
        return this.rise;
    }

    @Nullable
    public ZonedDateTime getSet() {
        return this.set;
    }

    public boolean isAlwaysUp() {
        return this.alwaysUp;
    }

    public boolean isAlwaysDown() {
        return this.alwaysDown;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MoonTimes[rise=").append(this.rise);
        sb.append(", set=").append(this.set);
        sb.append(", alwaysUp=").append(this.alwaysUp);
        sb.append(", alwaysDown=").append(this.alwaysDown);
        sb.append(']');
        return sb.toString();
    }

    private static class MoonTimesBuilder
    extends BaseBuilder<Parameters>
    implements Parameters {
        private double refraction = ExtendedMath.apparentRefraction(0.0);

        private MoonTimesBuilder() {
        }

        @Override
        public MoonTimes execute() {
            double upperLimitHours;
            double lowerLimitHours;
            int hourStep;
            if (!this.hasLocation()) {
                throw new IllegalArgumentException("Geolocation is missing.");
            }
            JulianDate jd = this.getJulianDate();
            Double rise = null;
            Double set = null;
            boolean alwaysUp = false;
            boolean alwaysDown = false;
            if (this.getDuration().isNegative()) {
                hourStep = -1;
                lowerLimitHours = (double)this.getDuration().toMillis() / 3600000.0;
                upperLimitHours = 0.0;
            } else {
                hourStep = 1;
                lowerLimitHours = 0.0;
                upperLimitHours = (double)this.getDuration().toMillis() / 3600000.0;
            }
            int hour = 0;
            int minHours = (int)Math.floor(lowerLimitHours);
            int maxHours = (int)Math.ceil(upperLimitHours);
            double y_minus = this.correctedMoonHeight(jd.atHour((double)hour - 1.0));
            double y_0 = this.correctedMoonHeight(jd.atHour(hour));
            double y_plus = this.correctedMoonHeight(jd.atHour((double)hour + 1.0));
            if (y_0 > 0.0) {
                alwaysUp = true;
            } else {
                alwaysDown = true;
            }
            while (hour <= maxHours && hour >= minHours) {
                double rt;
                QuadraticInterpolation qi = new QuadraticInterpolation(y_minus, y_0, y_plus);
                double ye = qi.getYe();
                if (qi.getNumberOfRoots() == 1) {
                    rt = qi.getRoot1() + (double)hour;
                    if (y_minus < 0.0) {
                        if (rise == null && rt >= lowerLimitHours && rt < upperLimitHours) {
                            rise = rt;
                            alwaysDown = false;
                        }
                    } else if (set == null && rt >= lowerLimitHours && rt < upperLimitHours) {
                        set = rt;
                        alwaysUp = false;
                    }
                } else if (qi.getNumberOfRoots() == 2) {
                    if (rise == null && (rt = (double)hour + (ye < 0.0 ? qi.getRoot2() : qi.getRoot1())) >= lowerLimitHours && rt < upperLimitHours) {
                        rise = rt;
                        alwaysDown = false;
                    }
                    if (set == null && (rt = (double)hour + (ye < 0.0 ? qi.getRoot1() : qi.getRoot2())) >= lowerLimitHours && rt < upperLimitHours) {
                        set = rt;
                        alwaysUp = false;
                    }
                }
                if (rise != null && set != null) break;
                hour += hourStep;
                if (hourStep > 0) {
                    y_minus = y_0;
                    y_0 = y_plus;
                    y_plus = this.correctedMoonHeight(jd.atHour((double)hour + 1.0));
                    continue;
                }
                y_plus = y_0;
                y_0 = y_minus;
                y_minus = this.correctedMoonHeight(jd.atHour((double)hour - 1.0));
            }
            return new MoonTimes(rise != null ? jd.atHour(rise).getDateTime() : null, set != null ? jd.atHour(set).getDateTime() : null, alwaysUp, alwaysDown);
        }

        private double correctedMoonHeight(JulianDate jd) {
            Vector pos = Moon.positionHorizontal(jd, this.getLatitudeRad(), this.getLongitudeRad());
            double hc = ExtendedMath.parallax(this.getElevation(), pos.getR()) - this.refraction - Moon.angularRadius(pos.getR());
            return pos.getTheta() - hc;
        }
    }

    public static interface Parameters
    extends GenericParameter<Parameters>,
    LocationParameter<Parameters>,
    TimeParameter<Parameters>,
    WindowParameter<Parameters>,
    Builder<MoonTimes> {
    }
}

