/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.commons.suncalc;

import org.shredzone.commons.suncalc.MoonPhase;
import org.shredzone.commons.suncalc.param.Builder;
import org.shredzone.commons.suncalc.param.GenericParameter;
import org.shredzone.commons.suncalc.param.LocationParameter;
import org.shredzone.commons.suncalc.param.TimeParameter;
import org.shredzone.commons.suncalc.util.BaseBuilder;
import org.shredzone.commons.suncalc.util.JulianDate;
import org.shredzone.commons.suncalc.util.Moon;
import org.shredzone.commons.suncalc.util.Sun;
import org.shredzone.commons.suncalc.util.Vector;

public class MoonIllumination {
    private final double fraction;
    private final double phase;
    private final double angle;
    private final double elongation;
    private final double radius;
    private final double crescentWidth;

    private MoonIllumination(double fraction, double phase, double angle, double elongation, double radius, double crescentWidth) {
        this.fraction = fraction;
        this.phase = phase;
        this.angle = angle;
        this.elongation = elongation;
        this.radius = radius;
        this.crescentWidth = crescentWidth;
    }

    public static Parameters compute() {
        return new MoonIlluminationBuilder();
    }

    public double getFraction() {
        return this.fraction;
    }

    public double getPhase() {
        return this.phase;
    }

    public double getAngle() {
        return this.angle;
    }

    public MoonPhase.Phase getClosestPhase() {
        return MoonPhase.Phase.toPhase(this.phase + 180.0);
    }

    public double getElongation() {
        return this.elongation;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getCrescentWidth() {
        return this.crescentWidth;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MoonIllumination[fraction=").append(this.fraction);
        sb.append(", phase=").append(this.phase);
        sb.append("\u00b0, angle=").append(this.angle);
        sb.append("\u00b0, elongation=").append(this.elongation);
        sb.append("\u00b0, radius=").append(this.radius);
        sb.append("\u00b0, crescentWidth=").append(this.crescentWidth);
        sb.append("\u00b0]");
        return sb.toString();
    }

    private static class MoonIlluminationBuilder
    extends BaseBuilder<Parameters>
    implements Parameters {
        private MoonIlluminationBuilder() {
        }

        @Override
        public Parameters geocentric() {
            this.clearLocation();
            return this;
        }

        @Override
        public MoonIllumination execute() {
            Vector mTopo;
            Vector sTopo;
            JulianDate t = this.getJulianDate();
            Vector s = Sun.position(t);
            Vector m = Moon.position(t);
            double phi = Math.PI - Math.acos(m.dot(s) / (m.getR() * s.getR()));
            Vector sunMoon = m.cross(s);
            double angle = Math.atan2(Math.cos(s.getTheta()) * Math.sin(s.getPhi() - m.getPhi()), Math.sin(s.getTheta()) * Math.cos(m.getTheta()) - Math.cos(s.getTheta()) * Math.sin(m.getTheta()) * Math.cos(s.getPhi() - m.getPhi()));
            if (this.hasLocation()) {
                sTopo = Sun.positionTopocentric(t, this.getLatitudeRad(), this.getLongitudeRad(), this.getElevation());
                mTopo = Moon.positionTopocentric(t, this.getLatitudeRad(), this.getLongitudeRad(), this.getElevation());
            } else {
                sTopo = s;
                mTopo = m;
            }
            double r = mTopo.subtract(sTopo).norm();
            double re = sTopo.norm();
            double d = mTopo.norm();
            double elongation = Math.acos((d * d + re * re - r * r) / (2.0 * d * re));
            double moonRadius = Moon.angularRadius(mTopo.getR());
            double crescentWidth = moonRadius * (1.0 - Math.cos(elongation));
            return new MoonIllumination((1.0 + Math.cos(phi)) / 2.0, Math.toDegrees(phi * Math.signum(sunMoon.getTheta())), Math.toDegrees(angle), Math.toDegrees(elongation), Math.toDegrees(moonRadius), Math.toDegrees(crescentWidth));
        }
    }

    public static interface Parameters
    extends GenericParameter<Parameters>,
    TimeParameter<Parameters>,
    LocationParameter<Parameters>,
    Builder<MoonIllumination> {
        public Parameters geocentric();
    }
}

