/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.seleniumhq.selenium.fluent.FluentWebElement;
import org.seleniumhq.selenium.fluent.Internal;
import org.seleniumhq.selenium.fluent.Monitor;
import org.seleniumhq.selenium.fluent.Period;
import org.seleniumhq.selenium.fluent.internal.Context;
import org.seleniumhq.selenium.fluent.internal.Execution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentSelect
extends FluentWebElement {
    private Select currentSelect;

    protected FluentSelect(WebDriver delegate, WebElement currentElement, Context context, Monitor monitor, boolean booleanInsteadOfNoSuchElement) {
        super(delegate, new Internal.WebElementHolder(null, currentElement, null), context, monitor, booleanInsteadOfNoSuchElement);
    }

    protected FluentSelect(WebDriver delegate, Select currentSelect, WebElement currentElement, Context context, Monitor monitor, boolean booleanInsteadOfNoSuchElement) {
        super(delegate, new Internal.WebElementHolder(null, currentElement, null), context, monitor, booleanInsteadOfNoSuchElement);
        this.currentSelect = currentSelect;
    }

    @Override
    public FluentSelect ifInvisibleWaitUpTo(Period period) {
        Context ifInvisibleWaitUpTo = Context.singular(this.context, "ifInvisibleWaitUpTo", period);
        this.executeAndWrapReThrowIfNeeded(new FluentWebElement.IfInvisibleWait((FluentWebElement)this, period), ifInvisibleWaitUpTo, true);
        return new FluentSelect(this.delegate, this.currentElement.getFound(), ifInvisibleWaitUpTo, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    public boolean isMultiple() {
        return this.executeAndWrapReThrowIfNeeded(new IsMultiple(), Context.singular(this.context, "isMultiple"), true);
    }

    public List<WebElement> getOptions() {
        return this.executeAndWrapReThrowIfNeeded(new GetOptions(), Context.singular(this.context, "getOptions"), true);
    }

    public List<WebElement> getAllSelectedOptions() {
        return this.executeAndWrapReThrowIfNeeded(new GetAllSelectedOptions(), Context.singular(this.context, "getAllSelectedOptions"), true);
    }

    public WebElement getFirstSelectedOption() {
        return this.executeAndWrapReThrowIfNeeded(new GetFirstSelectedOption(), Context.singular(this.context, "getFirstSelectedOption"), true);
    }

    public FluentSelect selectByVisibleText(String text) {
        this.executeAndWrapReThrowIfNeeded(new SelectByVisibleText(text), Context.singular(this.context, "selectByVisibleText", null, text), true);
        return new FluentSelect(this.delegate, this.currentElement.getFound(), this.context, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    public FluentSelect selectByIndex(int index) {
        this.executeAndWrapReThrowIfNeeded(new SelectByIndex(index), Context.singular(this.context, "selectByIndex", null, index), true);
        return new FluentSelect(this.delegate, this.currentElement.getFound(), this.context, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    public FluentSelect selectByValue(String value) {
        this.executeAndWrapReThrowIfNeeded(new SelectByValue(value), Context.singular(this.context, "selectByValue", null, value), true);
        return new FluentSelect(this.delegate, this.currentElement.getFound(), this.context, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    public FluentSelect deselectAll() {
        this.executeAndWrapReThrowIfNeeded(new DeselectAll(), Context.singular(this.context, "deselectAll"), true);
        return new FluentSelect(this.delegate, this.currentElement.getFound(), this.context, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    public FluentSelect deselectByValue(String value) {
        this.executeAndWrapReThrowIfNeeded(new DeselectByValue(value), Context.singular(this.context, "deselectByValue", null, value), true);
        return new FluentSelect(this.delegate, this.currentElement.getFound(), this.context, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    private <T> T executeAndWrapReThrowIfNeeded(Execution<T> execution, Context ctx, boolean expectedToBeThere) {
        return this.executeAndWrapReThrowIfNeeded(execution, this.currentElement, ctx, expectedToBeThere);
    }

    public FluentSelect deselectByIndex(int index) {
        this.executeAndWrapReThrowIfNeeded(new DeselectByIndex(index), Context.singular(this.context, "deselectByIndex", null, index), true);
        return new FluentSelect(this.delegate, this.currentElement.getFound(), this.context, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    public FluentSelect deselectByVisibleText(String text) {
        this.executeAndWrapReThrowIfNeeded(new DeselectByVisibleText(text), Context.singular(this.context, "deselectByVisibleText", null, text), true);
        return new FluentSelect(this.delegate, this.currentElement.getFound(), this.context, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    protected synchronized Select getSelect() {
        if (this.currentSelect == null) {
            this.currentSelect = new Select(this.currentElement.getFound());
        }
        return this.currentSelect;
    }

    @Override
    public FluentSelect within(Period period) {
        return new RetryingFluentSelect(this.delegate, Context.singular(this.context, "within", null, period), this.currentSelect, this.currentElement.getFound(), period, this.monitor, this.booleanInsteadOfNotFoundException);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeselectByVisibleText
    extends Execution<Boolean> {
        private final String text;

        public DeselectByVisibleText(String text) {
            this.text = text;
        }

        @Override
        public Boolean execute() {
            FluentSelect.this.getSelect().deselectByVisibleText(this.text);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeselectByIndex
    extends Execution<Boolean> {
        private final int index;

        public DeselectByIndex(int index) {
            this.index = index;
        }

        @Override
        public Boolean execute() {
            FluentSelect.this.getSelect().deselectByIndex(this.index);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeselectByValue
    extends Execution<Boolean> {
        private final String value;

        public DeselectByValue(String value) {
            this.value = value;
        }

        @Override
        public Boolean execute() {
            FluentSelect.this.getSelect().deselectByValue(this.value);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsMultiple
    extends Execution<Boolean> {
        private IsMultiple() {
        }

        @Override
        public Boolean execute() {
            return FluentSelect.this.getSelect().isMultiple();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetOptions
    extends Execution<List<WebElement>> {
        private GetOptions() {
        }

        @Override
        public List<WebElement> execute() {
            return FluentSelect.this.getSelect().getOptions();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetAllSelectedOptions
    extends Execution<List<WebElement>> {
        private GetAllSelectedOptions() {
        }

        @Override
        public List<WebElement> execute() {
            return FluentSelect.this.getSelect().getAllSelectedOptions();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetFirstSelectedOption
    extends Execution<WebElement> {
        private GetFirstSelectedOption() {
        }

        @Override
        public WebElement execute() {
            return FluentSelect.this.getSelect().getFirstSelectedOption();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectByVisibleText
    extends Execution<Boolean> {
        private final String text;

        public SelectByVisibleText(String text) {
            this.text = text;
        }

        @Override
        public Boolean execute() {
            FluentSelect.this.getSelect().selectByVisibleText(this.text);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectByIndex
    extends Execution<Boolean> {
        private final int index;

        public SelectByIndex(int index) {
            this.index = index;
        }

        @Override
        public Boolean execute() {
            FluentSelect.this.getSelect().selectByIndex(this.index);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectByValue
    extends Execution<Boolean> {
        private final String value;

        public SelectByValue(String value) {
            this.value = value;
        }

        @Override
        public Boolean execute() {
            Select select = FluentSelect.this.getSelect();
            select.selectByValue(this.value);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeselectAll
    extends Execution<Boolean> {
        private DeselectAll() {
        }

        @Override
        public Boolean execute() {
            FluentSelect.this.getSelect().deselectAll();
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RetryingFluentSelect
    extends FluentSelect {
        private final Period period;

        public RetryingFluentSelect(WebDriver webDriver, Context context, Select currentSelect, WebElement currentElement, Period period, Monitor monitor, boolean booleanInsteadOfNoSuchElement) {
            super(webDriver, currentSelect, currentElement, context, monitor, booleanInsteadOfNoSuchElement);
            this.period = period;
        }

        @Override
        protected WebElement findElement(By by, Context ctx, SearchContext searchContext) {
            return this.retryingFindIt(by, searchContext);
        }

        @Override
        protected List<WebElement> findElements(By by, Context ctx) {
            return this.retryingFindThem(by);
        }

        @Override
        protected Period getPeriod() {
            return this.period;
        }

        @Override
        protected void changeTimeout() {
            this.delegate.manage().timeouts().implicitlyWait((long)this.period.howLong(), this.period.timeUnit());
        }

        @Override
        protected void resetTimeout() {
            this.delegate.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        }
    }
}

