/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.writer.xmlgraphics;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.xmlgraphics.image.codec.util.SeekableOutputStream;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.writer.model.ImageWriter;
import org.sejda.model.exception.SejdaRuntimeException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.parameter.image.AbstractPdfToImageParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractImageWriterAdapter<T extends AbstractPdfToImageParameters>
implements ImageWriter<T> {
    private OutputStream outputDestination;

    AbstractImageWriterAdapter() {
    }

    @Override
    public void openWriteDestination(File destination, T params) throws TaskIOException {
        try {
            this.openWriteDestination((OutputStream)new SeekableOutputStream(new RandomAccessFile(destination, "rw")), params);
        }
        catch (FileNotFoundException e) {
            throw new TaskIOException("Unable to find destination file.", (Throwable)e);
        }
    }

    public void setOutputStream(OutputStream destination) {
        if (destination == null) {
            throw new SejdaRuntimeException("Destination for the ImageWriter cannot be null");
        }
        this.outputDestination = destination;
    }

    @Override
    public void closeDestination() throws TaskIOException {
        try {
            ComponentsUtility.nullSafeClose((Closeable)this.outputDestination);
        }
        catch (IOException e) {
            throw new TaskIOException((Throwable)e);
        }
    }

    OutputStream getOutputDestination() {
        return this.outputDestination;
    }

    @Override
    public void close() throws IOException {
        ComponentsUtility.nullSafeClose((Closeable)this.getOutputDestination());
    }
}

