/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.data;

import org.rrd4j.ConsolFun;
import org.rrd4j.data.Aggregates;
import org.rrd4j.data.DataProcessor;
import org.rrd4j.data.NonRrdSource;
import org.rrd4j.data.Source;

class SDef
extends Source
implements NonRrdSource {
    private String defName;
    private ConsolFun consolFun;
    private double value;

    SDef(String name, String defName, ConsolFun consolFun) {
        super(name);
        this.defName = defName;
        this.consolFun = consolFun;
    }

    String getDefName() {
        return this.defName;
    }

    ConsolFun getConsolFun() {
        return this.consolFun;
    }

    void setValue(double value) {
        this.value = value;
        int count = this.getTimestamps().length;
        double[] values = new double[count];
        for (int i = 0; i < count; ++i) {
            values[i] = value;
        }
        this.setValues(values);
    }

    @Override
    Aggregates getAggregates(long tStart, long tEnd) {
        Aggregates agg = new Aggregates();
        agg.max = agg.average = this.value;
        agg.min = agg.average;
        agg.last = agg.average;
        agg.first = agg.average;
        agg.total = this.value * (double)(tEnd - tStart);
        return agg;
    }

    @Override
    public void calculate(long tStart, long tEnd, DataProcessor dataProcessor) {
        String defName = this.getDefName();
        ConsolFun consolFun = this.getConsolFun();
        Source source = dataProcessor.getSource(defName);
        double value = source.getAggregates(tStart, tEnd).getAggregate(consolFun);
        this.setValue(value);
    }
}

