/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.Util;
import org.rrd4j.core.XmlWriter;

public class RrdDef {
    public static final long DEFAULT_STEP = 300L;
    public static final long DEFAULT_INITIAL_SHIFT = -10L;
    public static final int DEFAULTVERSION = 1;
    private String path;
    private long startTime = Util.getTime() + -10L;
    private long step = 300L;
    private int version = 1;
    private List<DsDef> dsDefs = new ArrayList<DsDef>();
    private List<ArcDef> arcDefs = new ArrayList<ArcDef>();

    public RrdDef(String path) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("No path specified");
        }
        this.path = path;
    }

    public RrdDef(String path, long step) {
        this(path);
        if (step <= 0L) {
            throw new IllegalArgumentException("Invalid RRD step specified: " + step);
        }
        this.step = step;
    }

    public RrdDef(String path, long startTime, long step) {
        this(path, step);
        if (startTime < 0L) {
            throw new IllegalArgumentException("Invalid RRD start time specified: " + startTime);
        }
        this.startTime = startTime;
    }

    public RrdDef(String path, long startTime, long step, int version) {
        this(path, startTime, step);
        if (startTime < 0L) {
            throw new IllegalArgumentException("Invalid RRD start time specified: " + startTime);
        }
        this.version = version;
    }

    public String getPath() {
        return this.path;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStep() {
        return this.step;
    }

    public int getVersion() {
        return this.version;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setStartTime(Date date) {
        this.startTime = Util.getTimestamp(date);
    }

    public void setStartTime(Calendar gc) {
        this.startTime = Util.getTimestamp(gc);
    }

    public void setStep(long step) {
        this.step = step;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void addDatasource(DsDef dsDef) {
        if (this.dsDefs.contains(dsDef)) {
            throw new IllegalArgumentException("Datasource already defined: " + dsDef.dump());
        }
        this.dsDefs.add(dsDef);
    }

    public void addDatasource(String dsName, DsType dsType, long heartbeat, double minValue, double maxValue) {
        this.addDatasource(new DsDef(dsName, dsType, heartbeat, minValue, maxValue));
    }

    public void addDatasource(String rrdToolDsDef) {
        long dsHeartbeat;
        IllegalArgumentException illArgException = new IllegalArgumentException("Wrong rrdtool-like datasource definition: " + rrdToolDsDef);
        if (rrdToolDsDef == null) {
            throw illArgException;
        }
        StringTokenizer tokenizer = new StringTokenizer(rrdToolDsDef, ":");
        if (tokenizer.countTokens() != 6) {
            throw illArgException;
        }
        String[] tokens = new String[6];
        int curTok = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[curTok] = tokenizer.nextToken();
            ++curTok;
        }
        if (!tokens[0].equalsIgnoreCase("DS")) {
            throw illArgException;
        }
        String dsName = tokens[1];
        DsType dsType = DsType.valueOf(tokens[2]);
        try {
            dsHeartbeat = Long.parseLong(tokens[3]);
        }
        catch (NumberFormatException nfe) {
            throw illArgException;
        }
        double minValue = Double.NaN;
        if (!tokens[4].equalsIgnoreCase("U")) {
            try {
                minValue = Double.parseDouble(tokens[4]);
            }
            catch (NumberFormatException nfe) {
                throw illArgException;
            }
        }
        double maxValue = Double.NaN;
        if (!tokens[5].equalsIgnoreCase("U")) {
            try {
                maxValue = Double.parseDouble(tokens[5]);
            }
            catch (NumberFormatException nfe) {
                throw illArgException;
            }
        }
        this.addDatasource(new DsDef(dsName, dsType, dsHeartbeat, minValue, maxValue));
    }

    public void addDatasource(DsDef ... dsDefs) {
        for (DsDef dsDef : dsDefs) {
            this.addDatasource(dsDef);
        }
    }

    public void addArchive(ArcDef arcDef) {
        if (this.arcDefs.contains(arcDef)) {
            throw new IllegalArgumentException("Archive already defined: " + arcDef.dump());
        }
        this.arcDefs.add(arcDef);
    }

    public void addArchive(ArcDef ... arcDefs) {
        for (ArcDef arcDef : arcDefs) {
            this.addArchive(arcDef);
        }
    }

    public void addArchive(ConsolFun consolFun, double xff, int steps, int rows) {
        this.addArchive(new ArcDef(consolFun, xff, steps, rows));
    }

    public void addArchive(String rrdToolArcDef) {
        int rows;
        int steps;
        double xff;
        IllegalArgumentException illArgException = new IllegalArgumentException("Wrong rrdtool-like archive definition: " + rrdToolArcDef);
        StringTokenizer tokenizer = new StringTokenizer(rrdToolArcDef, ":");
        if (tokenizer.countTokens() != 5) {
            throw illArgException;
        }
        String[] tokens = new String[5];
        int curTok = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[curTok] = tokenizer.nextToken();
            ++curTok;
        }
        if (!tokens[0].equalsIgnoreCase("RRA")) {
            throw illArgException;
        }
        ConsolFun consolFun = ConsolFun.valueOf(tokens[1]);
        try {
            xff = Double.parseDouble(tokens[2]);
        }
        catch (NumberFormatException nfe) {
            throw illArgException;
        }
        try {
            steps = Integer.parseInt(tokens[3]);
        }
        catch (NumberFormatException nfe) {
            throw illArgException;
        }
        try {
            rows = Integer.parseInt(tokens[4]);
        }
        catch (NumberFormatException nfe) {
            throw illArgException;
        }
        this.addArchive(new ArcDef(consolFun, xff, steps, rows));
    }

    public DsDef[] getDsDefs() {
        return this.dsDefs.toArray(new DsDef[this.dsDefs.size()]);
    }

    public ArcDef[] getArcDefs() {
        return this.arcDefs.toArray(new ArcDef[0]);
    }

    public int getDsCount() {
        return this.dsDefs.size();
    }

    public int getArcCount() {
        return this.arcDefs.size();
    }

    public String dump() {
        StringBuilder sb = new StringBuilder("create \"");
        sb.append(this.path).append("\"");
        sb.append(" --version ").append(this.getVersion());
        sb.append(" --start ").append(this.getStartTime());
        sb.append(" --step ").append(this.getStep()).append(" ");
        for (DsDef dsDef : this.dsDefs) {
            sb.append(dsDef.dump()).append(" ");
        }
        for (ArcDef arcDef : this.arcDefs) {
            sb.append(arcDef.dump()).append(" ");
        }
        return sb.toString().trim();
    }

    String getRrdToolCommand() {
        return this.dump();
    }

    void removeDatasource(String dsName) {
        for (int i = 0; i < this.dsDefs.size(); ++i) {
            DsDef dsDef = this.dsDefs.get(i);
            if (!dsDef.getDsName().equals(dsName)) continue;
            this.dsDefs.remove(i);
            return;
        }
        throw new IllegalArgumentException("Could not find datasource named '" + dsName + "'");
    }

    void saveSingleDatasource(String dsName) {
        Iterator<DsDef> it = this.dsDefs.iterator();
        while (it.hasNext()) {
            DsDef dsDef = it.next();
            if (dsDef.getDsName().equals(dsName)) continue;
            it.remove();
        }
    }

    void removeArchive(ConsolFun consolFun, int steps) {
        ArcDef arcDef = this.findArchive(consolFun, steps);
        if (!this.arcDefs.remove(arcDef)) {
            throw new IllegalArgumentException("Could not remove archive " + (Object)((Object)consolFun) + "/" + steps);
        }
    }

    ArcDef findArchive(ConsolFun consolFun, int steps) {
        for (ArcDef arcDef : this.arcDefs) {
            if (arcDef.getConsolFun() != consolFun || arcDef.getSteps() != steps) continue;
            return arcDef;
        }
        throw new IllegalArgumentException("Could not find archive " + (Object)((Object)consolFun) + "/" + steps);
    }

    public void exportXmlTemplate(OutputStream out) {
        ArcDef[] arcDefs;
        DsDef[] dsDefs;
        XmlWriter xml = new XmlWriter(out);
        xml.startTag("rrd_def");
        xml.writeTag("path", this.getPath());
        xml.writeTag("step", this.getStep());
        xml.writeTag("start", this.getStartTime());
        for (DsDef dsDef : dsDefs = this.getDsDefs()) {
            xml.startTag("datasource");
            xml.writeTag("name", dsDef.getDsName());
            xml.writeTag("type", (Object)dsDef.getDsType());
            xml.writeTag("heartbeat", dsDef.getHeartbeat());
            xml.writeTag("min", dsDef.getMinValue(), "U");
            xml.writeTag("max", dsDef.getMaxValue(), "U");
            xml.closeTag();
        }
        for (ArcDef arcDef : arcDefs = this.getArcDefs()) {
            xml.startTag("archive");
            xml.writeTag("cf", (Object)arcDef.getConsolFun());
            xml.writeTag("xff", arcDef.getXff());
            xml.writeTag("steps", arcDef.getSteps());
            xml.writeTag("rows", arcDef.getRows());
            xml.closeTag();
        }
        xml.closeTag();
        xml.flush();
    }

    public String exportXmlTemplate() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.exportXmlTemplate(out);
        return out.toString();
    }

    public void exportXmlTemplate(String filePath) throws IOException {
        FileOutputStream out = new FileOutputStream(filePath, false);
        this.exportXmlTemplate(out);
        out.close();
    }

    public long getEstimatedSize() {
        int dsCount = this.dsDefs.size();
        int arcCount = this.arcDefs.size();
        int rowsCount = 0;
        for (ArcDef arcDef : this.arcDefs) {
            rowsCount += arcDef.getRows();
        }
        return RrdDef.calculateSize(dsCount, arcCount, rowsCount);
    }

    static long calculateSize(int dsCount, int arcCount, int rowsCount) {
        return 24L + 48L * (long)dsCount + 16L * (long)arcCount + 20L * (long)dsCount * (long)arcCount + 8L * (long)dsCount * (long)rowsCount + (1L + 2L * (long)dsCount + (long)arcCount) * 2L * 20L;
    }

    public boolean equals(Object obj) {
        ArcDef[] arcDefs2;
        DsDef[] dsDefs2;
        if (obj == null || !(obj instanceof RrdDef)) {
            return false;
        }
        RrdDef rrdDef2 = (RrdDef)obj;
        if (this.step != rrdDef2.step) {
            return false;
        }
        DsDef[] dsDefs = this.getDsDefs();
        if (dsDefs.length != (dsDefs2 = rrdDef2.getDsDefs()).length) {
            return false;
        }
        for (DsDef dsDef : dsDefs) {
            boolean matched = false;
            for (DsDef aDsDefs2 : dsDefs2) {
                if (!dsDef.exactlyEqual(aDsDefs2)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        ArcDef[] arcDefs = this.getArcDefs();
        if (arcDefs.length != (arcDefs2 = rrdDef2.getArcDefs()).length) {
            return false;
        }
        for (ArcDef arcDef : arcDefs) {
            boolean matched = false;
            for (ArcDef anArcDefs2 : arcDefs2) {
                if (!arcDef.exactlyEqual(anArcDefs2)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public boolean hasDatasources() {
        return !this.dsDefs.isEmpty();
    }

    public boolean hasArchives() {
        return !this.arcDefs.isEmpty();
    }

    public void removeDatasources() {
        this.dsDefs.clear();
    }

    public void removeArchives() {
        this.arcDefs.clear();
    }
}

