/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdBerkeleyDbBackend;

public class RrdBerkeleyDbBackendFactory
extends RrdBackendFactory {
    private final Database rrdDatabase;
    private final Set<String> pathCache = new CopyOnWriteArraySet<String>();

    public RrdBerkeleyDbBackendFactory(Database rrdDatabase) {
        this.rrdDatabase = rrdDatabase;
        RrdBackendFactory.registerAndSetAsDefaultFactory(this);
    }

    @Override
    protected RrdBackend open(String path, boolean readOnly) throws IOException {
        if (this.pathCache.contains(path)) {
            DatabaseEntry theKey = new DatabaseEntry(path.getBytes("UTF-8"));
            DatabaseEntry theData = new DatabaseEntry();
            try {
                this.rrdDatabase.get(null, theKey, theData, LockMode.DEFAULT);
            }
            catch (DatabaseException de) {
                throw new IOException("BerkeleyDB DatabaseException on " + path + "; " + de.getMessage());
            }
            return new RrdBerkeleyDbBackend(theData.getData(), path, this.rrdDatabase);
        }
        return new RrdBerkeleyDbBackend(path, this.rrdDatabase);
    }

    public void delete(String path) {
        try {
            this.rrdDatabase.delete(null, new DatabaseEntry(path.getBytes("UTF-8")));
        }
        catch (DatabaseException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
        catch (IOException ie) {
            throw new IllegalArgumentException(path + ": " + ie.getMessage(), ie);
        }
        this.pathCache.remove(path);
    }

    @Override
    protected boolean exists(String path) throws IOException {
        if (this.pathCache.contains(path)) {
            return true;
        }
        DatabaseEntry theKey = new DatabaseEntry(path.getBytes("UTF-8"));
        theKey.setPartial(0, 0, true);
        DatabaseEntry theData = new DatabaseEntry();
        try {
            boolean pathExists;
            boolean bl = pathExists = this.rrdDatabase.get(null, theKey, theData, LockMode.DEFAULT) == OperationStatus.SUCCESS;
            if (pathExists) {
                this.pathCache.add(path);
            }
            return pathExists;
        }
        catch (DatabaseException de) {
            throw new IOException("BerkeleyDB DatabaseException on " + path + "; " + de.getMessage());
        }
    }

    @Override
    protected boolean shouldValidateHeader(String path) {
        return false;
    }

    @Override
    public String getName() {
        return "BERKELEY";
    }
}

