/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.esotericsoftware.kryo.util.Pool;
import com.esotericsoftware.kryo.util.Util;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Kryo5Codec
extends BaseCodec {
    private static final Logger logger = LoggerFactory.getLogger(Kryo5Codec.class);
    private static final List<String> MISSED_COLLECTION_CLASSES = Arrays.asList("Unmodifiable", "Synchronized", "Checked");
    private final Pool<Kryo> kryoPool;
    private final Pool<Input> inputPool;
    private final Pool<Output> outputPool;
    private final Set<String> allowedClasses;
    private final boolean useReferences;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            Kryo kryo = (Kryo)Kryo5Codec.this.kryoPool.obtain();
            Input input = (Input)Kryo5Codec.this.inputPool.obtain();
            try {
                input.setInputStream((InputStream)new ByteBufInputStream(buf));
                Object object = kryo.readClassAndObject(input);
                return object;
            }
            finally {
                Kryo5Codec.this.kryoPool.free((Object)kryo);
                Kryo5Codec.this.inputPool.free((Object)input);
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            Kryo kryo = (Kryo)Kryo5Codec.this.kryoPool.obtain();
            Output output = (Output)Kryo5Codec.this.outputPool.obtain();
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ByteBufOutputStream baos = new ByteBufOutputStream(out);
                output.setOutputStream((OutputStream)baos);
                kryo.writeClassAndObject(output, in);
                output.flush();
                ByteBuf byteBuf = baos.buffer();
                return byteBuf;
            }
            catch (RuntimeException e) {
                out.release();
                throw e;
            }
            finally {
                Kryo5Codec.this.kryoPool.free((Object)kryo);
                Kryo5Codec.this.outputPool.free((Object)output);
            }
        }
    };

    public Kryo5Codec() {
        this(null, Collections.emptySet(), false);
    }

    public Kryo5Codec(Set<String> allowedClasses, boolean useReferences) {
        this(null, allowedClasses, useReferences);
    }

    public Kryo5Codec(ClassLoader classLoader, Kryo5Codec codec) {
        this(classLoader, codec.allowedClasses, codec.useReferences);
    }

    public Kryo5Codec(ClassLoader classLoader) {
        this(classLoader, Collections.emptySet(), false);
    }

    public Kryo5Codec(final ClassLoader classLoader, Set<String> allowedClasses, final boolean useReferences) {
        this.allowedClasses = allowedClasses;
        this.useReferences = useReferences;
        this.kryoPool = new Pool<Kryo>(true, false, 1024){

            protected Kryo create() {
                try {
                    return Kryo5Codec.this.createKryo(classLoader, useReferences);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        this.inputPool = new Pool<Input>(true, false, 512){

            protected Input create() {
                return new Input(8192);
            }
        };
        this.outputPool = new Pool<Output>(true, false, 512){

            protected Output create() {
                return new Output(8192, -1);
            }
        };
    }

    protected Kryo createKryo(ClassLoader classLoader, boolean useReferences) throws ClassNotFoundException {
        Kryo kryo = new Kryo();
        if (classLoader != null) {
            kryo.setClassLoader(classLoader);
        }
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new SimpleInstantiatorStrategy());
        kryo.setRegistrationRequired(!this.allowedClasses.isEmpty());
        kryo.setReferences(useReferences);
        for (String allowedClass : this.allowedClasses) {
            kryo.register(Class.forName(allowedClass));
        }
        try {
            Class<?>[] f = Collections.class.getDeclaredClasses();
            Arrays.stream(f).filter(cls -> MISSED_COLLECTION_CLASSES.stream().anyMatch(s -> cls.getName().contains((CharSequence)s))).forEach(cls -> kryo.addDefaultSerializer(cls, (Serializer)new JavaSerializer()));
        }
        catch (Exception e) {
            logger.warn("Unable to register Collections serializer", (Throwable)e);
        }
        kryo.addDefaultSerializer(EnumMap.class, (Serializer)new JavaSerializer());
        kryo.addDefaultSerializer(Throwable.class, (Serializer)new JavaSerializer());
        kryo.addDefaultSerializer(UUID.class, (Serializer)new DefaultSerializers.UUIDSerializer());
        kryo.addDefaultSerializer(URI.class, (Serializer)new DefaultSerializers.URISerializer());
        kryo.addDefaultSerializer(Pattern.class, (Serializer)new DefaultSerializers.PatternSerializer());
        kryo.addDefaultSerializer(SocketAddress.class, (Serializer)new JavaSerializer());
        kryo.addDefaultSerializer(InetAddress.class, (Serializer)new JavaSerializer());
        kryo.addDefaultSerializer(AtomicBoolean.class, (Serializer)new DefaultSerializers.AtomicBooleanSerializer());
        kryo.addDefaultSerializer(AtomicInteger.class, (Serializer)new DefaultSerializers.AtomicIntegerSerializer());
        kryo.addDefaultSerializer(AtomicLong.class, (Serializer)new DefaultSerializers.AtomicLongSerializer());
        kryo.addDefaultSerializer(AtomicReference.class, (Serializer)new DefaultSerializers.AtomicReferenceSerializer());
        return kryo;
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }

    private static final class SimpleInstantiatorStrategy
    implements InstantiatorStrategy {
        private final StdInstantiatorStrategy ss = new StdInstantiatorStrategy();

        private SimpleInstantiatorStrategy() {
        }

        public <T> ObjectInstantiator<T> newInstantiatorOf(final Class<T> type) {
            try {
                Constructor<T> ctor;
                try {
                    ctor = type.getConstructor(null);
                }
                catch (Exception ex) {
                    ctor = type.getDeclaredConstructor(null);
                    ctor.setAccessible(true);
                }
                final Constructor<T> constructor = ctor;
                return new ObjectInstantiator(){

                    public Object newInstance() {
                        try {
                            return constructor.newInstance(new Object[0]);
                        }
                        catch (Exception ex) {
                            throw new KryoException("Error constructing instance of class: " + Util.className((Class)type), (Throwable)ex);
                        }
                    }
                };
            }
            catch (Exception exception) {
                return this.ss.newInstantiatorOf(type);
            }
        }
    }
}

