/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import io.netty.buffer.ByteBuf;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonObject;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.cache.AbstractCacheMap;
import org.redisson.cache.CacheKey;
import org.redisson.cache.CacheValue;
import org.redisson.cache.LFUCacheMap;
import org.redisson.cache.LRUCacheMap;
import org.redisson.cache.NoOpCacheMap;
import org.redisson.cache.NoneCacheMap;
import org.redisson.cache.ReferenceCacheMap;
import org.redisson.misc.Hash;

public class LocalCacheView<K, V> {
    private final RedissonObject object;
    private final ConcurrentMap<CacheKey, CacheValue> cache;
    private final ConcurrentMap<Object, CacheKey> cacheKeyMap;
    private final boolean useObjectAsCacheKey;

    public LocalCacheView(LocalCachedMapOptions<?, ?> options, RedissonObject object) {
        this.cache = this.createCache(options);
        this.object = object;
        this.cacheKeyMap = this.createCache(options);
        this.useObjectAsCacheKey = options.isUseObjectAsCacheKey();
    }

    public Set<K> cachedKeySet() {
        return new LocalKeySet();
    }

    public Collection<V> cachedValues() {
        return new LocalValues();
    }

    public Set<Map.Entry<K, V>> cachedEntrySet() {
        return new LocalEntrySet();
    }

    public Map<K, V> getCachedMap() {
        return new LocalMap();
    }

    protected V toValue(CacheValue cv) {
        return (V)cv.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey toCacheKey(Object key) {
        CacheKey cacheKey;
        if (this.useObjectAsCacheKey && (cacheKey = (CacheKey)this.cacheKeyMap.get(key)) != null) {
            return cacheKey;
        }
        ByteBuf encoded = this.object.encodeMapKey(key);
        try {
            CacheKey cacheKey2 = this.toCacheKey(encoded);
            return cacheKey2;
        }
        finally {
            encoded.release();
        }
    }

    public void putCacheKey(Object key, CacheKey cacheKey) {
        if (this.useObjectAsCacheKey) {
            this.cacheKeyMap.put(key, cacheKey);
        }
    }

    public CacheKey toCacheKey(ByteBuf encodedKey) {
        return new CacheKey(Hash.hash128toArray(encodedKey));
    }

    public <K1, V1> ConcurrentMap<K1, V1> getCache() {
        return this.cache;
    }

    public ConcurrentMap<Object, CacheKey> getCacheKeyMap() {
        return this.cacheKeyMap;
    }

    public <K1, V1> ConcurrentMap<K1, V1> createCache(LocalCachedMapOptions<?, ?> options) {
        if (options.getCacheSize() == -1) {
            return new NoOpCacheMap();
        }
        if (options.getCacheProvider() == LocalCachedMapOptions.CacheProvider.CAFFEINE) {
            Caffeine caffeineBuilder = Caffeine.newBuilder();
            if (options.getTimeToLiveInMillis() > 0L) {
                caffeineBuilder.expireAfterWrite(options.getTimeToLiveInMillis(), TimeUnit.MILLISECONDS);
            }
            if (options.getMaxIdleInMillis() > 0L) {
                caffeineBuilder.expireAfterAccess(options.getMaxIdleInMillis(), TimeUnit.MILLISECONDS);
            }
            if (options.getCacheSize() > 0) {
                caffeineBuilder.maximumSize((long)options.getCacheSize());
            }
            if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.SOFT) {
                caffeineBuilder.softValues();
            }
            if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.WEAK) {
                caffeineBuilder.weakValues();
            }
            return caffeineBuilder.build().asMap();
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.NONE) {
            return new NoneCacheMap(options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.LRU) {
            return new LRUCacheMap(options.getCacheSize(), options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.LFU) {
            return new LFUCacheMap(options.getCacheSize(), options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.SOFT) {
            return ReferenceCacheMap.soft(options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.WEAK) {
            return ReferenceCacheMap.weak(options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        throw new IllegalArgumentException("Invalid eviction policy: " + (Object)((Object)options.getEvictionPolicy()));
    }

    class LocalKeySet
    extends AbstractSet<K> {
        LocalKeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                private Iterator<CacheValue> iter;
                {
                    this.iter = LocalCacheView.this.cache.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public K next() {
                    return this.iter.next().getKey();
                }

                @Override
                public void remove() {
                    if (LocalCacheView.this.useObjectAsCacheKey) {
                        LocalCacheView.this.cacheKeyMap.remove(((AbstractCacheMap.MapIterator)this.iter).cursorValue().getKey());
                    }
                    this.iter.remove();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            CacheKey cacheKey = LocalCacheView.this.toCacheKey(o);
            return LocalCacheView.this.cache.containsKey(cacheKey);
        }

        @Override
        public boolean remove(Object o) {
            CacheKey cacheKey = LocalCacheView.this.toCacheKey(o);
            if (LocalCacheView.this.useObjectAsCacheKey) {
                LocalCacheView.this.cacheKeyMap.remove(o);
            }
            return LocalCacheView.this.cache.remove(cacheKey) != null;
        }

        @Override
        public int size() {
            return LocalCacheView.this.cache.size();
        }

        @Override
        public void clear() {
            if (LocalCacheView.this.useObjectAsCacheKey) {
                LocalCacheView.this.cacheKeyMap.clear();
            }
            LocalCacheView.this.cache.clear();
        }
    }

    final class LocalValues
    extends AbstractCollection<V> {
        LocalValues() {
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                private Iterator<CacheValue> iter;
                {
                    this.iter = LocalCacheView.this.cache.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public V next() {
                    return this.iter.next().getValue();
                }

                @Override
                public void remove() {
                    if (LocalCacheView.this.useObjectAsCacheKey) {
                        LocalCacheView.this.cacheKeyMap.remove(((AbstractCacheMap.MapIterator)this.iter).cursorValue().getKey());
                    }
                    this.iter.remove();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            CacheValue cacheValue = new CacheValue(null, o);
            return LocalCacheView.this.cache.containsValue(cacheValue);
        }

        @Override
        public int size() {
            return LocalCacheView.this.cache.size();
        }

        @Override
        public void clear() {
            LocalCacheView.this.cache.clear();
            if (LocalCacheView.this.useObjectAsCacheKey) {
                LocalCacheView.this.cacheKeyMap.clear();
            }
        }
    }

    final class LocalEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        LocalEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private Iterator<CacheValue> iter;
                {
                    this.iter = LocalCacheView.this.cache.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    CacheValue e = this.iter.next();
                    Object val = LocalCacheView.this.toValue(e);
                    return new AbstractMap.SimpleEntry(e.getKey(), val);
                }

                @Override
                public void remove() {
                    if (LocalCacheView.this.useObjectAsCacheKey) {
                        LocalCacheView.this.cacheKeyMap.remove(((AbstractCacheMap.MapIterator)this.iter).cursorValue().getKey());
                    }
                    this.iter.remove();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            CacheKey cacheKey = LocalCacheView.this.toCacheKey(e.getKey());
            CacheValue entry = (CacheValue)LocalCacheView.this.cache.get(cacheKey);
            return entry != null && entry.getValue().equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                CacheKey cacheKey = LocalCacheView.this.toCacheKey(e.getKey());
                if (LocalCacheView.this.useObjectAsCacheKey) {
                    LocalCacheView.this.cacheKeyMap.remove(e.getKey());
                }
                return LocalCacheView.this.cache.remove(cacheKey) != null;
            }
            return false;
        }

        @Override
        public int size() {
            return LocalCacheView.this.cache.size();
        }

        @Override
        public void clear() {
            LocalCacheView.this.cache.clear();
        }
    }

    final class LocalMap
    extends AbstractMap<K, V> {
        LocalMap() {
        }

        @Override
        public V get(Object key) {
            CacheKey cacheKey = LocalCacheView.this.toCacheKey(key);
            CacheValue e = (CacheValue)LocalCacheView.this.cache.get(cacheKey);
            if (e != null) {
                return e.getValue();
            }
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            CacheKey cacheKey = LocalCacheView.this.toCacheKey(key);
            return LocalCacheView.this.cache.containsKey(cacheKey);
        }

        @Override
        public boolean containsValue(Object value) {
            CacheValue cacheValue = new CacheValue(null, value);
            return LocalCacheView.this.cache.containsValue(cacheValue);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return LocalCacheView.this.cachedEntrySet();
        }
    }
}

