/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.ArrayList;
import java.util.function.LongConsumer;
import org.redisson.RedissonKeys;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.api.RType;
import org.redisson.api.options.KeysScanOptions;
import org.redisson.api.options.KeysScanParams;
import org.redisson.client.RedisClient;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.IteratorConsumer;
import reactor.core.publisher.Flux;

public class RedissonKeysReactive {
    private final CommandReactiveExecutor commandExecutor;
    private final RedissonKeys instance;

    public RedissonKeysReactive(CommandReactiveExecutor commandExecutor) {
        this.instance = new RedissonKeys(commandExecutor);
        this.commandExecutor = commandExecutor;
    }

    public Flux<String> getKeys() {
        return this.getKeysByPattern(null);
    }

    public Flux<String> getKeys(int count) {
        return this.getKeysByPattern(null, count);
    }

    public Flux<String> getKeysByPattern(String pattern) {
        return this.getKeysByPattern(pattern, 10);
    }

    public Flux<String> getKeysByPattern(String pattern, int count) {
        return this.getKeys(KeysScanOptions.defaults().pattern(pattern).chunkSize(count));
    }

    public Flux<String> getKeys(KeysScanOptions options) {
        KeysScanParams params = (KeysScanParams)options;
        ArrayList<Flux<String>> publishers = new ArrayList<Flux<String>>();
        for (MasterSlaveEntry entry : this.commandExecutor.getConnectionManager().getEntrySet()) {
            publishers.add(this.createKeysIterator(entry, params.getPattern(), params.getChunkSize(), params.getType()));
        }
        return Flux.merge(publishers);
    }

    private Flux<String> createKeysIterator(final MasterSlaveEntry entry, final String pattern, final int count, final RType type) {
        return Flux.create(emitter -> emitter.onRequest((LongConsumer)new IteratorConsumer<String>(emitter){

            @Override
            protected boolean tryAgain() {
                return false;
            }

            @Override
            protected RFuture<ScanResult<Object>> scanIterator(RedisClient client, String nextIterPos) {
                return RedissonKeysReactive.this.instance.scanIteratorAsync(client, entry, nextIterPos, pattern, count, type);
            }
        }));
    }
}

