/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.eviction;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.command.CommandAsyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class EvictionTask
implements TimerTask {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final Deque<Integer> sizeHistory = new LinkedList<Integer>();
    final int minDelay;
    final int maxDelay;
    final int keysLimit;
    int delay = 5;
    final CommandAsyncExecutor executor;
    volatile Timeout timeout;

    EvictionTask(CommandAsyncExecutor executor) {
        this.executor = executor;
        this.minDelay = executor.getServiceManager().getCfg().getMinCleanUpDelay();
        this.maxDelay = executor.getServiceManager().getCfg().getMaxCleanUpDelay();
        this.keysLimit = executor.getServiceManager().getCfg().getCleanUpKeysAmount();
        this.delay = this.minDelay;
    }

    public void schedule() {
        this.timeout = this.executor.getServiceManager().newTimeout(this, this.delay, TimeUnit.SECONDS);
    }

    public void cancel() {
        this.timeout.cancel();
    }

    abstract RFuture<Integer> execute();

    abstract String getName();

    public void run(Timeout timeout) {
        if (this.executor.getServiceManager().isShuttingDown()) {
            return;
        }
        RFuture<Integer> future = this.execute();
        future.whenComplete((size, e) -> {
            if (e != null) {
                this.log.error("Unable to evict elements for '{}'", (Object)this.getName(), e);
                this.schedule();
                return;
            }
            this.log.debug("{} elements evicted. Object name: {}", size, (Object)this.getName());
            if (size == -1) {
                this.schedule();
                return;
            }
            if (this.sizeHistory.size() == 2) {
                if (this.sizeHistory.peekFirst() > this.sizeHistory.peekLast() && this.sizeHistory.peekLast() > size) {
                    this.delay = Math.min(this.maxDelay, (int)((double)this.delay * 1.5));
                }
                if (this.sizeHistory.peekFirst().intValue() == this.sizeHistory.peekLast().intValue() && this.sizeHistory.peekLast().intValue() == size.intValue()) {
                    if (size >= this.keysLimit) {
                        this.delay = Math.max(this.minDelay, this.delay / 4);
                    }
                    if (size == 0) {
                        this.delay = Math.min(this.maxDelay, (int)((double)this.delay * 1.5));
                    }
                }
                this.sizeHistory.pollFirst();
            }
            this.sizeHistory.add((Integer)size);
            this.schedule();
        });
    }
}

