/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.LongConsumer;
import io.reactivex.rxjava3.processors.ReplayProcessor;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;

public abstract class SetRxIterator<V> {
    public Flowable<V> create() {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){
            private String nextIterPos = "0";
            private RedisClient client;
            private AtomicLong elementsRead = new AtomicLong();
            private boolean finished;
            private volatile boolean completed;
            private AtomicLong readAmount = new AtomicLong();

            public void accept(long value) {
                this.readAmount.addAndGet(value);
                if (this.completed || this.elementsRead.get() == 0L) {
                    this.nextValues();
                    this.completed = false;
                }
            }

            protected void nextValues() {
                SetRxIterator.this.scanIterator(this.client, this.nextIterPos).whenComplete((res, e) -> {
                    if (e != null) {
                        p.onError(e);
                        return;
                    }
                    if (this.finished) {
                        this.client = null;
                        this.nextIterPos = "0";
                        return;
                    }
                    this.client = res.getRedisClient();
                    this.nextIterPos = res.getPos();
                    for (Object val : res.getValues()) {
                        p.onNext(val);
                        this.elementsRead.incrementAndGet();
                    }
                    if (this.elementsRead.get() >= this.readAmount.get()) {
                        p.onComplete();
                        this.elementsRead.set(0L);
                        this.completed = true;
                        return;
                    }
                    if ("0".equals(res.getPos()) && !SetRxIterator.this.tryAgain()) {
                        this.finished = true;
                        p.onComplete();
                    }
                    if (this.finished || this.completed) {
                        return;
                    }
                    this.nextValues();
                });
            }
        });
    }

    protected boolean tryAgain() {
        return false;
    }

    protected abstract RFuture<ScanResult<Object>> scanIterator(RedisClient var1, String var2);
}

