/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.redisson.connection.ServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementsSubscribeService {
    private static final Logger log = LoggerFactory.getLogger(ElementsSubscribeService.class);
    private final Map<Integer, CompletableFuture<?>> subscribeListeners = new ConcurrentHashMap();
    private final ServiceManager serviceManager;

    public ElementsSubscribeService(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public <V> int subscribeOnElements(Supplier<CompletionStage<V>> func, Function<V, CompletionStage<Void>> consumer) {
        int id = System.identityHashCode(consumer);
        CompletableFuture<Object> currentFuture = this.subscribeListeners.putIfAbsent(id, CompletableFuture.completedFuture(null));
        if (currentFuture != null) {
            throw new IllegalArgumentException("Consumer object with listener id " + id + " already registered");
        }
        this.resubscribe(func, consumer);
        return id;
    }

    public <V> int subscribeOnElements(Supplier<CompletionStage<V>> func, Consumer<V> consumer) {
        int id = System.identityHashCode(consumer);
        CompletableFuture<Object> currentFuture = this.subscribeListeners.putIfAbsent(id, CompletableFuture.completedFuture(null));
        if (currentFuture != null) {
            throw new IllegalArgumentException("Consumer object with listener id " + id + " already registered");
        }
        this.resubscribe(func, consumer);
        return id;
    }

    public void unsubscribe(int listenerId) {
        CompletableFuture<?> f = this.subscribeListeners.remove(listenerId);
        if (f != null) {
            f.cancel(false);
        }
    }

    private <V> void resubscribe(Supplier<CompletionStage<V>> func, Consumer<V> consumer) {
        int listenerId = System.identityHashCode(consumer);
        CompletionStage f = this.subscribeListeners.computeIfPresent(listenerId, (k, v) -> ((CompletionStage)func.get()).toCompletableFuture());
        if (f == null) {
            return;
        }
        f.whenComplete((r, e) -> {
            if (e != null) {
                this.serviceManager.newTimeout(arg_0 -> this.lambda$resubscribe$1((Supplier)func, consumer, arg_0), 1L, TimeUnit.SECONDS);
                return;
            }
            consumer.accept(r);
            this.resubscribe(func, consumer);
        });
    }

    private <V> void resubscribe(Supplier<CompletionStage<V>> func, Function<V, CompletionStage<Void>> consumer) {
        int listenerId = System.identityHashCode(consumer);
        CompletionStage f = this.subscribeListeners.computeIfPresent(listenerId, (k, v) -> ((CompletionStage)func.get()).toCompletableFuture());
        if (f == null) {
            return;
        }
        f.thenCompose(consumer).whenComplete((r, ex) -> {
            if (ex != null) {
                log.error(ex.getMessage(), ex);
                this.serviceManager.newTimeout(arg_0 -> this.lambda$resubscribe$4((Supplier)func, consumer, arg_0), 1L, TimeUnit.SECONDS);
                return;
            }
            this.resubscribe(func, consumer);
        });
    }

    private /* synthetic */ void lambda$resubscribe$4(Supplier func, Function consumer, Timeout t) throws Exception {
        this.resubscribe(func, consumer);
    }

    private /* synthetic */ void lambda$resubscribe$1(Supplier func, Consumer consumer, Timeout t) throws Exception {
        this.resubscribe(func, consumer);
    }
}

