/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import java.util.Deque;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.connection.IdleConnectionWatcher;
import org.redisson.misc.AsyncSemaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnectionsEntry {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Queue<RedisPubSubConnection> allSubscribeConnections = new ConcurrentLinkedQueue<RedisPubSubConnection>();
    private final Queue<RedisPubSubConnection> freeSubscribeConnections = new ConcurrentLinkedQueue<RedisPubSubConnection>();
    private final AsyncSemaphore freeSubscribeConnectionsCounter;
    private final Queue<RedisConnection> allConnections = new ConcurrentLinkedQueue<RedisConnection>();
    private final Deque<RedisConnection> freeConnections = new ConcurrentLinkedDeque<RedisConnection>();
    private final AsyncSemaphore freeConnectionsCounter;
    private volatile FreezeReason freezeReason;
    final RedisClient client;
    private volatile NodeType nodeType;
    private final IdleConnectionWatcher idleConnectionWatcher;
    private final MasterSlaveServersConfig config;
    private volatile boolean initialized = false;

    public ClientConnectionsEntry(RedisClient client, int poolMinSize, int poolMaxSize, IdleConnectionWatcher idleConnectionWatcher, NodeType nodeType, MasterSlaveServersConfig config) {
        this.client = client;
        this.freeConnectionsCounter = new AsyncSemaphore(poolMaxSize);
        this.idleConnectionWatcher = idleConnectionWatcher;
        this.nodeType = nodeType;
        this.config = config;
        this.freeSubscribeConnectionsCounter = new AsyncSemaphore(config.getSubscriptionConnectionPoolSize());
        if (config.getSubscriptionConnectionPoolSize() > 0) {
            idleConnectionWatcher.add(this, config.getSubscriptionConnectionMinimumIdleSize(), config.getSubscriptionConnectionPoolSize(), this.freeSubscribeConnections, this.freeSubscribeConnectionsCounter, c -> {
                this.freeSubscribeConnections.remove(c);
                return this.allSubscribeConnections.remove(c);
            });
        }
        idleConnectionWatcher.add(this, poolMinSize, poolMaxSize, this.freeConnections, this.freeConnectionsCounter, c -> {
            this.freeConnections.remove(c);
            return this.allConnections.remove(c);
        });
    }

    public boolean isMasterForRead() {
        return this.getFreezeReason() == FreezeReason.SYSTEM && this.config.getReadMode() == ReadMode.MASTER_SLAVE && this.getNodeType() == NodeType.MASTER;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean isInited) {
        this.initialized = isInited;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void resetFirstFail() {
        this.client.resetFirstFail();
    }

    public boolean isFailed() {
        if (this.client.getFirstFailTime() != 0L) {
            return System.currentTimeMillis() - this.client.getFirstFailTime() > (long)this.config.getFailedSlaveCheckInterval();
        }
        return false;
    }

    public void trySetupFistFail() {
        this.client.trySetupFirstFail();
    }

    public CompletableFuture<Void> shutdownAsync() {
        this.idleConnectionWatcher.remove(this);
        return this.client.shutdownAsync().toCompletableFuture();
    }

    public RedisClient getClient() {
        return this.client;
    }

    public boolean isFreezed() {
        return this.freezeReason != null;
    }

    public void setFreezeReason(FreezeReason freezeReason) {
        this.freezeReason = freezeReason;
        if (freezeReason != null) {
            this.initialized = false;
        }
    }

    public FreezeReason getFreezeReason() {
        return this.freezeReason;
    }

    public void reset() {
        this.freeConnectionsCounter.removeListeners();
        this.freeSubscribeConnectionsCounter.removeListeners();
    }

    public CompletableFuture<Void> acquireConnection(RedisCommand<?> command) {
        return this.freeConnectionsCounter.acquire();
    }

    public void releaseConnection() {
        this.freeConnectionsCounter.release();
    }

    public void addConnection(RedisConnection conn) {
        conn.setLastUsageTime(System.nanoTime());
        if (conn instanceof RedisPubSubConnection) {
            this.freeSubscribeConnections.add((RedisPubSubConnection)conn);
        } else {
            this.freeConnections.add(conn);
        }
    }

    public RedisConnection pollConnection(RedisCommand<?> command) {
        RedisConnection c = this.freeConnections.poll();
        if (c != null) {
            c.incUsage();
        }
        return c;
    }

    public void releaseConnection(RedisConnection connection) {
        if (connection.isClosed()) {
            return;
        }
        if (this.client != connection.getRedisClient()) {
            connection.closeAsync();
            return;
        }
        connection.setLastUsageTime(System.nanoTime());
        this.freeConnections.add(connection);
        connection.decUsage();
    }

    public CompletionStage<RedisConnection> connect() {
        RFuture<RedisConnection> future = this.client.connectAsync();
        return future.whenComplete((conn, e) -> {
            if (e != null) {
                return;
            }
            this.log.debug("new connection created: {}", conn);
            this.allConnections.add((RedisConnection)conn);
        });
    }

    public CompletionStage<RedisPubSubConnection> connectPubSub() {
        RFuture<RedisPubSubConnection> future = this.client.connectPubSubAsync();
        return future.whenComplete((conn, e) -> {
            if (e != null) {
                return;
            }
            this.log.debug("new pubsub connection created: {}", conn);
            this.allSubscribeConnections.add((RedisPubSubConnection)conn);
        });
    }

    public Queue<RedisConnection> getAllConnections() {
        return this.allConnections;
    }

    public Queue<RedisPubSubConnection> getAllSubscribeConnections() {
        return this.allSubscribeConnections;
    }

    public RedisPubSubConnection pollSubscribeConnection() {
        return this.freeSubscribeConnections.poll();
    }

    public void releaseSubscribeConnection(RedisPubSubConnection connection) {
        if (connection.isClosed()) {
            return;
        }
        if (this.client != connection.getRedisClient()) {
            connection.closeAsync();
            return;
        }
        connection.setLastUsageTime(System.nanoTime());
        this.freeSubscribeConnections.add(connection);
    }

    public CompletableFuture<Void> acquireSubscribeConnection() {
        return this.freeSubscribeConnectionsCounter.acquire();
    }

    public void releaseSubscribeConnection() {
        this.freeSubscribeConnectionsCounter.release();
    }

    public String toString() {
        return "[freeSubscribeConnectionsAmount=" + this.freeSubscribeConnections.size() + ", freeSubscribeConnectionsCounter=" + this.freeSubscribeConnectionsCounter + ", freeConnectionsAmount=" + this.freeConnections.size() + ", freeConnectionsCounter=" + this.freeConnectionsCounter + ", freezeReason=" + (Object)((Object)this.freezeReason) + ", client=" + this.client + ", nodeType=" + (Object)((Object)this.nodeType) + ", firstFail=" + this.client.getFirstFailTime() + "]";
    }

    public static enum FreezeReason {
        MANAGER,
        RECONNECT,
        SYSTEM;

    }
}

