/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.CharsetUtil;
import org.redisson.client.ChannelName;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.CommandMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class CommandEncoder
extends MessageToByteEncoder<CommandData<?, ?>> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final char ARGS_PREFIX = '*';
    private static final char BYTES_PREFIX = '$';
    private static final byte[] CRLF = "\r\n".getBytes();
    private CommandMapper commandMapper;

    public CommandEncoder(CommandMapper commandMapper) {
        this.commandMapper = commandMapper;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.acceptOutboundMessage(msg) && !promise.setUncancellable()) {
            return;
        }
        try {
            super.write(ctx, msg, promise);
        }
        catch (Exception e) {
            promise.tryFailure((Throwable)e);
            throw e;
        }
    }

    protected void encode(ChannelHandlerContext ctx, CommandData<?, ?> msg, ByteBuf out) throws Exception {
        try {
            out.writeByte(42);
            int len = 1 + msg.getParams().length;
            if (msg.getCommand().getSubName() != null) {
                ++len;
            }
            out.writeCharSequence((CharSequence)Long.toString(len), CharsetUtil.US_ASCII);
            out.writeBytes(CRLF);
            String name = this.commandMapper.map(msg.getCommand().getName());
            this.writeArgument(out, name.getBytes(CharsetUtil.UTF_8));
            if (msg.getCommand().getSubName() != null) {
                this.writeArgument(out, msg.getCommand().getSubName().getBytes(CharsetUtil.UTF_8));
            }
            for (Object param : msg.getParams()) {
                ByteBuf buf = this.encode(param);
                this.writeArgument(out, buf);
                if (param instanceof ByteBuf) continue;
                buf.release();
            }
            if (this.log.isTraceEnabled()) {
                String info = out.toString(CharsetUtil.UTF_8);
                if (RedisCommands.AUTH.equals(msg.getCommand())) {
                    info = info.substring(0, info.indexOf(RedisCommands.AUTH.getName()) + RedisCommands.AUTH.getName().length()) + "(password masked)";
                }
                this.log.trace("channel: {} message: {}", (Object)ctx.channel(), (Object)info);
            }
        }
        catch (Exception e) {
            msg.tryFailure(e);
            throw e;
        }
    }

    private ByteBuf encode(Object in) {
        if (in == null) {
            return new EmptyByteBuf(ByteBufAllocator.DEFAULT);
        }
        if (in instanceof byte[]) {
            return Unpooled.wrappedBuffer((byte[])((byte[])in));
        }
        if (in instanceof ByteBuf) {
            return (ByteBuf)in;
        }
        if (in instanceof ChannelName) {
            return Unpooled.wrappedBuffer((byte[])((ChannelName)in).getName());
        }
        String payload = in.toString();
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(ByteBufUtil.utf8MaxBytes((CharSequence)payload));
        ByteBufUtil.writeUtf8((ByteBuf)buf, (CharSequence)payload);
        return buf;
    }

    private void writeArgument(ByteBuf out, byte[] arg) {
        out.writeByte(36);
        out.writeCharSequence((CharSequence)Long.toString(arg.length), CharsetUtil.US_ASCII);
        out.writeBytes(CRLF);
        out.writeBytes(arg);
        out.writeBytes(CRLF);
    }

    private void writeArgument(ByteBuf out, ByteBuf arg) {
        out.writeByte(36);
        out.writeCharSequence((CharSequence)Long.toString(arg.readableBytes()), CharsetUtil.US_ASCII);
        out.writeBytes(CRLF);
        out.writeBytes(arg, arg.readerIndex(), arg.readableBytes());
        out.writeBytes(CRLF);
    }
}

