/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.redisson.RedissonBaseLock;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RLockAsync;
import org.redisson.client.RedisResponseTimeoutException;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonMultiLock
implements RLock {
    final List<RLock> locks = new ArrayList<RLock>();

    public RedissonMultiLock(RLock ... locks) {
        if (locks.length == 0) {
            throw new IllegalArgumentException("Lock objects are not defined");
        }
        this.locks.addAll(Arrays.asList(locks));
    }

    @Override
    public void lock() {
        try {
            this.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void lock(long leaseTime, TimeUnit unit) {
        try {
            this.lockInterruptibly(leaseTime, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit) {
        return this.lockAsync(leaseTime, unit, Thread.currentThread().getId());
    }

    @Override
    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit, long threadId) {
        long waitTime;
        long baseWaitTime = this.locks.size() * 1500;
        waitTime = leaseTime <= 0L ? baseWaitTime : ((waitTime = (leaseTime = unit.toMillis(leaseTime))) <= 2000L ? 2000L : (waitTime <= baseWaitTime ? ThreadLocalRandom.current().nextLong(waitTime / 2L, waitTime) : ThreadLocalRandom.current().nextLong(baseWaitTime, waitTime)));
        CompletionStage<Void> f = this.tryLockAsyncCycle(threadId, leaseTime, TimeUnit.MILLISECONDS, waitTime);
        return new CompletableFutureWrapper<Void>(f);
    }

    protected CompletionStage<Void> tryLockAsyncCycle(long threadId, long leaseTime, TimeUnit unit, long waitTime) {
        return this.tryLockAsync(waitTime, leaseTime, unit, threadId).thenCompose(res -> {
            if (res.booleanValue()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.tryLockAsyncCycle(threadId, leaseTime, unit, waitTime);
        });
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lockInterruptibly(-1L, null);
    }

    @Override
    public void lockInterruptibly(long leaseTime, TimeUnit unit) throws InterruptedException {
        long waitTime;
        long baseWaitTime = this.locks.size() * 1500;
        while (!this.tryLock(waitTime = leaseTime <= 0L ? baseWaitTime : ((waitTime = unit.toMillis(leaseTime)) <= baseWaitTime ? ThreadLocalRandom.current().nextLong(waitTime / 2L, waitTime) : ThreadLocalRandom.current().nextLong(baseWaitTime, waitTime)), leaseTime, TimeUnit.MILLISECONDS)) {
        }
    }

    @Override
    public boolean tryLock() {
        try {
            return this.tryLock(-1L, -1L, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    protected void unlockInner(Collection<RLock> locks) {
        locks.stream().map(RLockAsync::unlockAsync).forEach(f -> {
            try {
                f.toCompletableFuture().join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    protected RFuture<Void> unlockInnerAsync(Collection<RLock> locks, long threadId) {
        ArrayList futures = new ArrayList(locks.size());
        for (RLock lock : locks) {
            RFuture<Void> f = lock.unlockAsync(threadId);
            futures.add(f.toCompletableFuture());
        }
        CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return new CompletableFutureWrapper<Void>(future);
    }

    @Override
    public boolean tryLock(long waitTime, TimeUnit unit) throws InterruptedException {
        return this.tryLock(waitTime, -1L, unit);
    }

    protected int failedLocksLimit() {
        return 0;
    }

    @Override
    public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        long newLeaseTime = -1L;
        if (leaseTime > 0L) {
            newLeaseTime = waitTime > 0L ? unit.toMillis(waitTime) * 2L : unit.toMillis(leaseTime);
        }
        long time = System.currentTimeMillis();
        long remainTime = -1L;
        if (waitTime > 0L) {
            remainTime = unit.toMillis(waitTime);
        }
        long lockWaitTime = this.calcLockWaitTime(remainTime);
        int failedLocksLimit = this.failedLocksLimit();
        ArrayList<RLock> acquiredLocks = new ArrayList<RLock>(this.locks.size());
        ListIterator<RLock> iterator = this.locks.listIterator();
        while (iterator.hasNext()) {
            boolean lockAcquired;
            RLock lock = iterator.next();
            try {
                if (waitTime <= 0L && leaseTime <= 0L) {
                    lockAcquired = lock.tryLock();
                } else {
                    long awaitTime = Math.min(lockWaitTime, remainTime);
                    lockAcquired = lock.tryLock(awaitTime, newLeaseTime, TimeUnit.MILLISECONDS);
                }
            }
            catch (RedisResponseTimeoutException e) {
                this.unlockInner(Arrays.asList(lock));
                lockAcquired = false;
            }
            catch (Exception e) {
                lockAcquired = false;
            }
            if (lockAcquired) {
                acquiredLocks.add(lock);
            } else {
                if (this.locks.size() - acquiredLocks.size() == this.failedLocksLimit()) break;
                if (failedLocksLimit == 0) {
                    this.unlockInner(acquiredLocks);
                    if (waitTime <= 0L) {
                        return false;
                    }
                    failedLocksLimit = this.failedLocksLimit();
                    acquiredLocks.clear();
                    while (iterator.hasPrevious()) {
                        iterator.previous();
                    }
                } else {
                    --failedLocksLimit;
                }
            }
            if (remainTime <= 0L) continue;
            time = System.currentTimeMillis();
            if ((remainTime -= System.currentTimeMillis() - time) > 0L) continue;
            this.unlockInner(acquiredLocks);
            return false;
        }
        if (leaseTime > 0L) {
            acquiredLocks.stream().map(l -> (RedissonBaseLock)l).map(l -> l.expireAsync(unit.toMillis(leaseTime), TimeUnit.MILLISECONDS)).forEach(f -> f.toCompletableFuture().join());
        }
        return true;
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit, long threadId) {
        LockState state = new LockState(waitTime, leaseTime, unit, threadId);
        CompletionStage<Boolean> f = state.tryAcquireLockAsync(this.locks.listIterator());
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit) {
        return this.tryLockAsync(waitTime, leaseTime, unit, Thread.currentThread().getId());
    }

    protected long calcLockWaitTime(long remainTime) {
        return remainTime;
    }

    @Override
    public RFuture<Void> unlockAsync(long threadId) {
        return this.unlockInnerAsync(this.locks, threadId);
    }

    @Override
    public void unlock() {
        ArrayList<RFuture<Void>> futures = new ArrayList<RFuture<Void>>(this.locks.size());
        for (RLock rLock : this.locks) {
            futures.add(rLock.unlockAsync());
        }
        for (RFuture rFuture : futures) {
            rFuture.toCompletableFuture().join();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> forceUnlockAsync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Void> unlockAsync() {
        return this.unlockAsync(Thread.currentThread().getId());
    }

    @Override
    public RFuture<Boolean> tryLockAsync() {
        return this.tryLockAsync(Thread.currentThread().getId());
    }

    @Override
    public RFuture<Void> lockAsync() {
        return this.lockAsync(Thread.currentThread().getId());
    }

    @Override
    public RFuture<Void> lockAsync(long threadId) {
        return this.lockAsync(-1L, null, threadId);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long threadId) {
        return this.tryLockAsync(-1L, -1L, null, threadId);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, TimeUnit unit) {
        return this.tryLockAsync(waitTime, -1L, unit);
    }

    @Override
    public RFuture<Integer> getHoldCountAsync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean forceUnlock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocked() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> isLockedAsync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHeldByThread(long threadId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHeldByCurrentThread() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getHoldCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long remainTimeToLive() {
        throw new UnsupportedOperationException();
    }

    class LockState {
        private final long newLeaseTime;
        private final long lockWaitTime;
        private final List<RLock> acquiredLocks;
        private final long waitTime;
        private final long threadId;
        private final long leaseTime;
        private final TimeUnit unit;
        private long remainTime;
        private long time = System.currentTimeMillis();
        private int failedLocksLimit;

        LockState(long waitTime, long leaseTime, TimeUnit unit, long threadId) {
            this.waitTime = waitTime;
            this.leaseTime = leaseTime;
            this.unit = unit;
            this.threadId = threadId;
            this.newLeaseTime = leaseTime > 0L ? (waitTime > 0L ? unit.toMillis(waitTime) * 2L : unit.toMillis(leaseTime)) : -1L;
            this.remainTime = -1L;
            if (waitTime > 0L) {
                this.remainTime = unit.toMillis(waitTime);
            }
            this.lockWaitTime = RedissonMultiLock.this.calcLockWaitTime(this.remainTime);
            this.failedLocksLimit = RedissonMultiLock.this.failedLocksLimit();
            this.acquiredLocks = new ArrayList<RLock>(RedissonMultiLock.this.locks.size());
        }

        CompletionStage<Boolean> tryAcquireLockAsync(ListIterator<RLock> iterator) {
            RFuture<Boolean> lockAcquiredFuture;
            if (!iterator.hasNext()) {
                return this.checkLeaseTimeAsync();
            }
            RLock lock = iterator.next();
            if (this.waitTime <= 0L && this.leaseTime <= 0L) {
                lockAcquiredFuture = lock.tryLockAsync(this.threadId);
            } else {
                long awaitTime = Math.min(this.lockWaitTime, this.remainTime);
                lockAcquiredFuture = lock.tryLockAsync(awaitTime, this.newLeaseTime, TimeUnit.MILLISECONDS, this.threadId);
            }
            return lockAcquiredFuture.exceptionally(e -> null).thenCompose(res -> {
                boolean lockAcquired = false;
                if (res != null) {
                    lockAcquired = res;
                } else {
                    RedissonMultiLock.this.unlockInnerAsync(Arrays.asList(lock), this.threadId);
                }
                if (lockAcquired) {
                    this.acquiredLocks.add(lock);
                } else {
                    if (RedissonMultiLock.this.locks.size() - this.acquiredLocks.size() == RedissonMultiLock.this.failedLocksLimit()) {
                        return this.checkLeaseTimeAsync();
                    }
                    if (this.failedLocksLimit == 0) {
                        return RedissonMultiLock.this.unlockInnerAsync(this.acquiredLocks, this.threadId).thenCompose(r -> {
                            if (this.waitTime <= 0L) {
                                return CompletableFuture.completedFuture(false);
                            }
                            this.failedLocksLimit = RedissonMultiLock.this.failedLocksLimit();
                            this.acquiredLocks.clear();
                            while (iterator.hasPrevious()) {
                                iterator.previous();
                            }
                            return this.checkRemainTimeAsync(iterator);
                        });
                    }
                    --this.failedLocksLimit;
                }
                return this.checkRemainTimeAsync(iterator);
            });
        }

        private CompletableFuture<Boolean> checkLeaseTimeAsync() {
            if (this.leaseTime > 0L) {
                ArrayList futures = new ArrayList();
                for (RLock rLock : this.acquiredLocks) {
                    RFuture future = ((RedissonBaseLock)rLock).expireAsync(this.unit.toMillis(this.leaseTime), TimeUnit.MILLISECONDS);
                    futures.add(future.toCompletableFuture());
                }
                CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
                return f.thenApply(r -> true);
            }
            return CompletableFuture.completedFuture(true);
        }

        private CompletionStage<Boolean> checkRemainTimeAsync(ListIterator<RLock> iterator) {
            if (this.remainTime > 0L) {
                this.remainTime += -(System.currentTimeMillis() - this.time);
                this.time = System.currentTimeMillis();
                if (this.remainTime <= 0L) {
                    return RedissonMultiLock.this.unlockInnerAsync(this.acquiredLocks, this.threadId).thenApply(res -> false);
                }
            }
            return this.tryAcquireLockAsync(iterator);
        }
    }
}

