/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;

public class JndiRedissonFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        RefAddr addr = ref.get("configPath");
        return this.buildClient(addr.getContent().toString());
    }

    protected RedissonClient buildClient(String configPath) throws NamingException {
        Config config = null;
        try {
            config = Config.fromYAML(new File(configPath), this.getClass().getClassLoader());
        }
        catch (IOException e) {
            try {
                config = Config.fromJSON(new File(configPath), this.getClass().getClassLoader());
            }
            catch (IOException e1) {
                NamingException ex = new NamingException("Can't parse yaml config " + configPath);
                ex.initCause(e1);
                throw ex;
            }
        }
        try {
            return Redisson.create(config);
        }
        catch (Exception e) {
            NamingException ex = new NamingException();
            ex.initCause(e);
            throw ex;
        }
    }
}

