/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.redisson.RedisNodes;
import org.redisson.RedissonAtomicDouble;
import org.redisson.RedissonAtomicLong;
import org.redisson.RedissonBinaryStream;
import org.redisson.RedissonBitSet;
import org.redisson.RedissonBlockingDeque;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonBucket;
import org.redisson.RedissonBuckets;
import org.redisson.RedissonCountDownLatch;
import org.redisson.RedissonDeque;
import org.redisson.RedissonFairLock;
import org.redisson.RedissonFuction;
import org.redisson.RedissonGeo;
import org.redisson.RedissonHyperLogLog;
import org.redisson.RedissonIdGenerator;
import org.redisson.RedissonKeys;
import org.redisson.RedissonLexSortedSet;
import org.redisson.RedissonList;
import org.redisson.RedissonListMultimap;
import org.redisson.RedissonListMultimapCache;
import org.redisson.RedissonLock;
import org.redisson.RedissonMap;
import org.redisson.RedissonMapCache;
import org.redisson.RedissonMultiLock;
import org.redisson.RedissonObject;
import org.redisson.RedissonPatternTopic;
import org.redisson.RedissonPermitExpirableSemaphore;
import org.redisson.RedissonQueue;
import org.redisson.RedissonRateLimiter;
import org.redisson.RedissonRedLock;
import org.redisson.RedissonReliableTopic;
import org.redisson.RedissonRemoteService;
import org.redisson.RedissonRingBuffer;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonScript;
import org.redisson.RedissonSemaphore;
import org.redisson.RedissonSet;
import org.redisson.RedissonSetCache;
import org.redisson.RedissonSetMultimap;
import org.redisson.RedissonSetMultimapCache;
import org.redisson.RedissonSpinLock;
import org.redisson.RedissonStream;
import org.redisson.RedissonTimeSeries;
import org.redisson.RedissonTopic;
import org.redisson.RedissonTransferQueue;
import org.redisson.WriteBehindService;
import org.redisson.api.BatchOptions;
import org.redisson.api.ClusterNode;
import org.redisson.api.LockOptions;
import org.redisson.api.MapOptions;
import org.redisson.api.Node;
import org.redisson.api.NodesGroup;
import org.redisson.api.RAtomicDoubleReactive;
import org.redisson.api.RAtomicLongReactive;
import org.redisson.api.RBatchReactive;
import org.redisson.api.RBinaryStreamReactive;
import org.redisson.api.RBitSetReactive;
import org.redisson.api.RBlockingDequeReactive;
import org.redisson.api.RBlockingQueueReactive;
import org.redisson.api.RBucketReactive;
import org.redisson.api.RBucketsReactive;
import org.redisson.api.RCountDownLatchReactive;
import org.redisson.api.RDequeReactive;
import org.redisson.api.RFunctionReactive;
import org.redisson.api.RGeoReactive;
import org.redisson.api.RHyperLogLogReactive;
import org.redisson.api.RIdGeneratorReactive;
import org.redisson.api.RKeysReactive;
import org.redisson.api.RLexSortedSetReactive;
import org.redisson.api.RListMultimapCacheReactive;
import org.redisson.api.RListMultimapReactive;
import org.redisson.api.RListReactive;
import org.redisson.api.RLock;
import org.redisson.api.RLockReactive;
import org.redisson.api.RMapCacheReactive;
import org.redisson.api.RMapReactive;
import org.redisson.api.RPatternTopicReactive;
import org.redisson.api.RPermitExpirableSemaphoreReactive;
import org.redisson.api.RQueueReactive;
import org.redisson.api.RRateLimiterReactive;
import org.redisson.api.RReadWriteLockReactive;
import org.redisson.api.RReliableTopicReactive;
import org.redisson.api.RRemoteService;
import org.redisson.api.RRingBufferReactive;
import org.redisson.api.RScoredSortedSetReactive;
import org.redisson.api.RScriptReactive;
import org.redisson.api.RSemaphoreReactive;
import org.redisson.api.RSetCacheReactive;
import org.redisson.api.RSetMultimapCacheReactive;
import org.redisson.api.RSetMultimapReactive;
import org.redisson.api.RSetReactive;
import org.redisson.api.RStreamReactive;
import org.redisson.api.RTimeSeriesReactive;
import org.redisson.api.RTopicReactive;
import org.redisson.api.RTransactionReactive;
import org.redisson.api.RTransferQueueReactive;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.api.TransactionOptions;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.config.Config;
import org.redisson.config.ConfigSupport;
import org.redisson.connection.ConnectionManager;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.CommandReactiveService;
import org.redisson.reactive.ReactiveProxyBuilder;
import org.redisson.reactive.RedissonBatchReactive;
import org.redisson.reactive.RedissonBinaryStreamReactive;
import org.redisson.reactive.RedissonBlockingDequeReactive;
import org.redisson.reactive.RedissonBlockingQueueReactive;
import org.redisson.reactive.RedissonKeysReactive;
import org.redisson.reactive.RedissonLexSortedSetReactive;
import org.redisson.reactive.RedissonListMultimapCacheReactive;
import org.redisson.reactive.RedissonListMultimapReactive;
import org.redisson.reactive.RedissonListReactive;
import org.redisson.reactive.RedissonMapCacheReactive;
import org.redisson.reactive.RedissonMapReactive;
import org.redisson.reactive.RedissonReadWriteLockReactive;
import org.redisson.reactive.RedissonReliableTopicReactive;
import org.redisson.reactive.RedissonScoredSortedSetReactive;
import org.redisson.reactive.RedissonSetCacheReactive;
import org.redisson.reactive.RedissonSetMultimapCacheReactive;
import org.redisson.reactive.RedissonSetMultimapReactive;
import org.redisson.reactive.RedissonSetReactive;
import org.redisson.reactive.RedissonTimeSeriesReactive;
import org.redisson.reactive.RedissonTopicReactive;
import org.redisson.reactive.RedissonTransactionReactive;
import org.redisson.reactive.RedissonTransferQueueReactive;
import org.redisson.remote.ResponseEntry;

public class RedissonReactive
implements RedissonReactiveClient {
    protected final WriteBehindService writeBehindService;
    protected final EvictionScheduler evictionScheduler;
    protected final CommandReactiveExecutor commandExecutor;
    protected final ConnectionManager connectionManager;
    protected final ConcurrentMap<String, ResponseEntry> responses;

    protected RedissonReactive(Config config) {
        Config configCopy = new Config(config);
        this.connectionManager = ConfigSupport.createConnectionManager(configCopy);
        RedissonObjectBuilder objectBuilder = null;
        if (config.isReferenceEnabled()) {
            objectBuilder = new RedissonObjectBuilder(this);
        }
        this.commandExecutor = new CommandReactiveService(this.connectionManager, objectBuilder);
        this.evictionScheduler = new EvictionScheduler(this.commandExecutor);
        this.writeBehindService = new WriteBehindService(this.commandExecutor);
        this.responses = new ConcurrentHashMap<String, ResponseEntry>();
    }

    protected RedissonReactive(ConnectionManager connectionManager, EvictionScheduler evictionScheduler, WriteBehindService writeBehindService, ConcurrentMap<String, ResponseEntry> responses) {
        this.connectionManager = connectionManager;
        RedissonObjectBuilder objectBuilder = null;
        if (connectionManager.getCfg().isReferenceEnabled()) {
            objectBuilder = new RedissonObjectBuilder(this);
        }
        this.commandExecutor = new CommandReactiveService(connectionManager, objectBuilder);
        this.evictionScheduler = evictionScheduler;
        this.writeBehindService = writeBehindService;
        this.responses = responses;
    }

    public EvictionScheduler getEvictionScheduler() {
        return this.evictionScheduler;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public CommandReactiveExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    @Override
    public <K, V> RStreamReactive<K, V> getStream(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonStream(this.commandExecutor, name), RStreamReactive.class);
    }

    @Override
    public <K, V> RStreamReactive<K, V> getStream(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonStream(codec, this.commandExecutor, name), RStreamReactive.class);
    }

    @Override
    public <V> RGeoReactive<V> getGeo(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonGeo(this.commandExecutor, name, null), new RedissonScoredSortedSetReactive(this.commandExecutor, name), RGeoReactive.class);
    }

    @Override
    public <V> RGeoReactive<V> getGeo(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonGeo(codec, this.commandExecutor, name, null), new RedissonScoredSortedSetReactive(codec, this.commandExecutor, name), RGeoReactive.class);
    }

    @Override
    public RLockReactive getFairLock(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonFairLock(this.commandExecutor, name), RLockReactive.class);
    }

    @Override
    public RRateLimiterReactive getRateLimiter(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonRateLimiter(this.commandExecutor, name), RRateLimiterReactive.class);
    }

    @Override
    public RBinaryStreamReactive getBinaryStream(String name) {
        RedissonBinaryStream stream = new RedissonBinaryStream(this.commandExecutor, name);
        return ReactiveProxyBuilder.create(this.commandExecutor, stream, new RedissonBinaryStreamReactive(this.commandExecutor, stream), RBinaryStreamReactive.class);
    }

    @Override
    public RSemaphoreReactive getSemaphore(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonSemaphore(this.commandExecutor, name), RSemaphoreReactive.class);
    }

    @Override
    public RPermitExpirableSemaphoreReactive getPermitExpirableSemaphore(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonPermitExpirableSemaphore(this.commandExecutor, name), RPermitExpirableSemaphoreReactive.class);
    }

    @Override
    public RReadWriteLockReactive getReadWriteLock(String name) {
        return new RedissonReadWriteLockReactive(this.commandExecutor, name);
    }

    @Override
    public RLockReactive getLock(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonLock(this.commandExecutor, name), RLockReactive.class);
    }

    @Override
    public RLockReactive getSpinLock(String name) {
        return this.getSpinLock(name, LockOptions.defaults());
    }

    @Override
    public RLockReactive getSpinLock(String name, LockOptions.BackOff backOff) {
        RedissonSpinLock spinLock = new RedissonSpinLock(this.commandExecutor, name, backOff);
        return ReactiveProxyBuilder.create(this.commandExecutor, spinLock, RLockReactive.class);
    }

    @Override
    public RLockReactive getMultiLock(RLockReactive ... locks) {
        RLock[] ls = (RLock[])Arrays.stream(locks).map(l -> new RedissonLock(this.commandExecutor, l.getName())).toArray(RLock[]::new);
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonMultiLock(ls), RLockReactive.class);
    }

    @Override
    public RLockReactive getMultiLock(RLock ... locks) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonMultiLock(locks), RLockReactive.class);
    }

    @Override
    public RLockReactive getRedLock(RLock ... locks) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonRedLock(locks), RLockReactive.class);
    }

    @Override
    public RCountDownLatchReactive getCountDownLatch(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonCountDownLatch(this.commandExecutor, name), RCountDownLatchReactive.class);
    }

    @Override
    public <K, V> RMapCacheReactive<K, V> getMapCache(String name, Codec codec) {
        RedissonMapCache map = new RedissonMapCache(codec, this.evictionScheduler, this.commandExecutor, name, null, null, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheReactive(map, this.commandExecutor), RMapCacheReactive.class);
    }

    @Override
    public <K, V> RMapCacheReactive<K, V> getMapCache(String name) {
        RedissonMapCache map = new RedissonMapCache(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name, null, null, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheReactive(map, this.commandExecutor), RMapCacheReactive.class);
    }

    @Override
    public <V> RBucketReactive<V> getBucket(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonBucket(this.commandExecutor, name), RBucketReactive.class);
    }

    @Override
    public <V> RBucketReactive<V> getBucket(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonBucket(codec, this.commandExecutor, name), RBucketReactive.class);
    }

    @Override
    public RBucketsReactive getBuckets() {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonBuckets(this.commandExecutor), RBucketsReactive.class);
    }

    @Override
    public RBucketsReactive getBuckets(Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonBuckets(codec, this.commandExecutor), RBucketsReactive.class);
    }

    @Override
    public <V> List<RBucketReactive<V>> findBuckets(String pattern) {
        RedissonKeys redissonKeys = new RedissonKeys(this.commandExecutor);
        Iterable<String> keys = redissonKeys.getKeysByPattern(pattern);
        ArrayList<RBucketReactive<V>> buckets = new ArrayList<RBucketReactive<V>>();
        for (String key : keys) {
            if (key == null) continue;
            buckets.add(this.getBucket(key.toString()));
        }
        return buckets;
    }

    @Override
    public <V> RHyperLogLogReactive<V> getHyperLogLog(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonHyperLogLog(this.commandExecutor, name), RHyperLogLogReactive.class);
    }

    @Override
    public <V> RHyperLogLogReactive<V> getHyperLogLog(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonHyperLogLog(codec, this.commandExecutor, name), RHyperLogLogReactive.class);
    }

    @Override
    public RIdGeneratorReactive getIdGenerator(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonIdGenerator(this.commandExecutor, name), RIdGeneratorReactive.class);
    }

    @Override
    public <V> RListReactive<V> getList(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonList(this.commandExecutor, name, null), new RedissonListReactive(this.commandExecutor, name), RListReactive.class);
    }

    @Override
    public <V> RListReactive<V> getList(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonList(codec, this.commandExecutor, name, null), new RedissonListReactive(codec, this.commandExecutor, name), RListReactive.class);
    }

    @Override
    public <K, V> RListMultimapReactive<K, V> getListMultimap(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonListMultimap(this.commandExecutor, name), new RedissonListMultimapReactive(this.commandExecutor, name), RListMultimapReactive.class);
    }

    @Override
    public <K, V> RListMultimapReactive<K, V> getListMultimap(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonListMultimap(codec, this.commandExecutor, name), new RedissonListMultimapReactive(codec, this.commandExecutor, name), RListMultimapReactive.class);
    }

    @Override
    public <K, V> RSetMultimapReactive<K, V> getSetMultimap(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonSetMultimap(this.commandExecutor, name), new RedissonSetMultimapReactive(this.commandExecutor, name, this), RSetMultimapReactive.class);
    }

    @Override
    public <K, V> RSetMultimapReactive<K, V> getSetMultimap(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonSetMultimap(codec, this.commandExecutor, name), new RedissonSetMultimapReactive(codec, this.commandExecutor, name, this), RSetMultimapReactive.class);
    }

    @Override
    public <K, V> RListMultimapCacheReactive<K, V> getListMultimapCache(String name) {
        RedissonListMultimapCache listMultimap = new RedissonListMultimapCache(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name);
        return ReactiveProxyBuilder.create(this.commandExecutor, listMultimap, new RedissonListMultimapCacheReactive(listMultimap, this.commandExecutor), RListMultimapCacheReactive.class);
    }

    @Override
    public <K, V> RListMultimapCacheReactive<K, V> getListMultimapCache(String name, Codec codec) {
        RedissonListMultimapCache listMultimap = new RedissonListMultimapCache(this.evictionScheduler, codec, this.commandExecutor, name);
        return ReactiveProxyBuilder.create(this.commandExecutor, listMultimap, new RedissonListMultimapCacheReactive(listMultimap, this.commandExecutor), RListMultimapCacheReactive.class);
    }

    @Override
    public <K, V> RSetMultimapCacheReactive<K, V> getSetMultimapCache(String name) {
        RedissonSetMultimapCache setMultimap = new RedissonSetMultimapCache(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name);
        return ReactiveProxyBuilder.create(this.commandExecutor, setMultimap, new RedissonSetMultimapCacheReactive(setMultimap, this.commandExecutor, this), RSetMultimapCacheReactive.class);
    }

    @Override
    public <K, V> RSetMultimapCacheReactive<K, V> getSetMultimapCache(String name, Codec codec) {
        RedissonSetMultimapCache setMultimap = new RedissonSetMultimapCache(this.evictionScheduler, codec, this.commandExecutor, name);
        return ReactiveProxyBuilder.create(this.commandExecutor, setMultimap, new RedissonSetMultimapCacheReactive(setMultimap, this.commandExecutor, this), RSetMultimapCacheReactive.class);
    }

    @Override
    public <K, V> RMapReactive<K, V> getMap(String name) {
        RedissonMap map = new RedissonMap(this.commandExecutor, name, null, null, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapReactive(map, this.commandExecutor), RMapReactive.class);
    }

    @Override
    public <K, V> RMapReactive<K, V> getMap(String name, Codec codec) {
        RedissonMap map = new RedissonMap(codec, this.commandExecutor, name, null, null, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapReactive(map, this.commandExecutor), RMapReactive.class);
    }

    @Override
    public <V> RSetReactive<V> getSet(String name) {
        RedissonSet set = new RedissonSet(this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, set, new RedissonSetReactive(set, this), RSetReactive.class);
    }

    @Override
    public <V> RSetReactive<V> getSet(String name, Codec codec) {
        RedissonSet set = new RedissonSet(codec, this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, set, new RedissonSetReactive(set, this), RSetReactive.class);
    }

    @Override
    public <V> RScoredSortedSetReactive<V> getScoredSortedSet(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonScoredSortedSet(this.commandExecutor, name, null), new RedissonScoredSortedSetReactive(this.commandExecutor, name), RScoredSortedSetReactive.class);
    }

    @Override
    public <V> RScoredSortedSetReactive<V> getScoredSortedSet(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonScoredSortedSet(codec, this.commandExecutor, name, null), new RedissonScoredSortedSetReactive(codec, this.commandExecutor, name), RScoredSortedSetReactive.class);
    }

    @Override
    public RLexSortedSetReactive getLexSortedSet(String name) {
        RedissonLexSortedSet set = new RedissonLexSortedSet(this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, set, new RedissonLexSortedSetReactive(set), RLexSortedSetReactive.class);
    }

    @Override
    public RTopicReactive getTopic(String name) {
        RedissonTopic topic = new RedissonTopic(this.commandExecutor, name);
        return ReactiveProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicReactive(topic), RTopicReactive.class);
    }

    @Override
    public RTopicReactive getTopic(String name, Codec codec) {
        RedissonTopic topic = new RedissonTopic(codec, this.commandExecutor, name);
        return ReactiveProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicReactive(topic), RTopicReactive.class);
    }

    @Override
    public RReliableTopicReactive getReliableTopic(String name) {
        RedissonReliableTopic topic = new RedissonReliableTopic(this.commandExecutor, name);
        return ReactiveProxyBuilder.create(this.commandExecutor, topic, new RedissonReliableTopicReactive(topic), RReliableTopicReactive.class);
    }

    @Override
    public RReliableTopicReactive getReliableTopic(String name, Codec codec) {
        RedissonReliableTopic topic = new RedissonReliableTopic(codec, this.commandExecutor, name);
        return ReactiveProxyBuilder.create(this.commandExecutor, topic, new RedissonReliableTopicReactive(topic), RReliableTopicReactive.class);
    }

    @Override
    public RPatternTopicReactive getPatternTopic(String pattern) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonPatternTopic(this.commandExecutor, pattern), RPatternTopicReactive.class);
    }

    @Override
    public RPatternTopicReactive getPatternTopic(String pattern, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonPatternTopic(codec, this.commandExecutor, pattern), RPatternTopicReactive.class);
    }

    @Override
    public <V> RQueueReactive<V> getQueue(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonQueue(this.commandExecutor, name, null), new RedissonListReactive(this.commandExecutor, name), RQueueReactive.class);
    }

    @Override
    public <V> RQueueReactive<V> getQueue(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonQueue(codec, this.commandExecutor, name, null), new RedissonListReactive(codec, this.commandExecutor, name), RQueueReactive.class);
    }

    @Override
    public <V> RRingBufferReactive<V> getRingBuffer(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonRingBuffer(this.commandExecutor, name, null), RRingBufferReactive.class);
    }

    @Override
    public <V> RRingBufferReactive<V> getRingBuffer(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonRingBuffer(codec, this.commandExecutor, name, null), RRingBufferReactive.class);
    }

    @Override
    public <V> RBlockingQueueReactive<V> getBlockingQueue(String name) {
        RedissonBlockingQueue queue = new RedissonBlockingQueue(this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, queue, new RedissonBlockingQueueReactive(queue), RBlockingQueueReactive.class);
    }

    @Override
    public <V> RBlockingQueueReactive<V> getBlockingQueue(String name, Codec codec) {
        RedissonBlockingQueue queue = new RedissonBlockingQueue(codec, this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, queue, new RedissonBlockingQueueReactive(queue), RBlockingQueueReactive.class);
    }

    @Override
    public <V> RDequeReactive<V> getDeque(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonDeque(this.commandExecutor, name, null), new RedissonListReactive(this.commandExecutor, name), RDequeReactive.class);
    }

    @Override
    public <V> RDequeReactive<V> getDeque(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonDeque(codec, this.commandExecutor, name, null), new RedissonListReactive(codec, this.commandExecutor, name), RDequeReactive.class);
    }

    @Override
    public <V> RTimeSeriesReactive<V> getTimeSeries(String name) {
        RedissonTimeSeries timeSeries = new RedissonTimeSeries(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name);
        return ReactiveProxyBuilder.create(this.commandExecutor, timeSeries, new RedissonTimeSeriesReactive(timeSeries, this), RTimeSeriesReactive.class);
    }

    @Override
    public <V> RTimeSeriesReactive<V> getTimeSeries(String name, Codec codec) {
        RedissonTimeSeries timeSeries = new RedissonTimeSeries(codec, this.evictionScheduler, this.commandExecutor, name);
        return ReactiveProxyBuilder.create(this.commandExecutor, timeSeries, new RedissonTimeSeriesReactive(timeSeries, this), RTimeSeriesReactive.class);
    }

    @Override
    public <V> RSetCacheReactive<V> getSetCache(String name) {
        RedissonSetCache set = new RedissonSetCache(this.evictionScheduler, this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, set, new RedissonSetCacheReactive(set, this), RSetCacheReactive.class);
    }

    @Override
    public <V> RSetCacheReactive<V> getSetCache(String name, Codec codec) {
        RedissonSetCache set = new RedissonSetCache(codec, this.evictionScheduler, this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, set, new RedissonSetCacheReactive(set, this), RSetCacheReactive.class);
    }

    @Override
    public RAtomicLongReactive getAtomicLong(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonAtomicLong(this.commandExecutor, name), RAtomicLongReactive.class);
    }

    @Override
    public RAtomicDoubleReactive getAtomicDouble(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonAtomicDouble(this.commandExecutor, name), RAtomicDoubleReactive.class);
    }

    @Override
    public RRemoteService getRemoteService() {
        return this.getRemoteService("redisson_rs", this.connectionManager.getCodec());
    }

    @Override
    public RRemoteService getRemoteService(String name) {
        return this.getRemoteService(name, this.connectionManager.getCodec());
    }

    @Override
    public RRemoteService getRemoteService(Codec codec) {
        return this.getRemoteService("redisson_rs", codec);
    }

    @Override
    public RRemoteService getRemoteService(String name, Codec codec) {
        String executorId = this.connectionManager.getId();
        if (codec != this.connectionManager.getCodec()) {
            executorId = executorId + ":" + name;
        }
        return new RedissonRemoteService(codec, name, this.commandExecutor, executorId, this.responses);
    }

    @Override
    public RBitSetReactive getBitSet(String name) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonBitSet(this.commandExecutor, name), RBitSetReactive.class);
    }

    @Override
    public RFunctionReactive getFunction() {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonFuction(this.commandExecutor), RFunctionReactive.class);
    }

    @Override
    public RFunctionReactive getFunction(Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonFuction(this.commandExecutor, codec), RFunctionReactive.class);
    }

    @Override
    public RScriptReactive getScript() {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonScript(this.commandExecutor), RScriptReactive.class);
    }

    @Override
    public RScriptReactive getScript(Codec codec) {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonScript(this.commandExecutor, codec), RScriptReactive.class);
    }

    @Override
    public RBatchReactive createBatch(BatchOptions options) {
        return new RedissonBatchReactive(this.evictionScheduler, this.connectionManager, this.commandExecutor, options);
    }

    @Override
    public RBatchReactive createBatch() {
        return this.createBatch(BatchOptions.defaults());
    }

    @Override
    public RKeysReactive getKeys() {
        return ReactiveProxyBuilder.create(this.commandExecutor, new RedissonKeys(this.commandExecutor), new RedissonKeysReactive(this.commandExecutor), RKeysReactive.class);
    }

    @Override
    public Config getConfig() {
        return this.connectionManager.getCfg();
    }

    @Override
    public NodesGroup<Node> getNodesGroup() {
        return new RedisNodes<Node>(this.connectionManager, this.commandExecutor);
    }

    @Override
    public NodesGroup<ClusterNode> getClusterNodesGroup() {
        if (!this.connectionManager.isClusterMode()) {
            throw new IllegalStateException("Redisson not in cluster mode!");
        }
        return new RedisNodes<ClusterNode>(this.connectionManager, this.commandExecutor);
    }

    @Override
    public void shutdown() {
        this.writeBehindService.stop();
        this.connectionManager.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.connectionManager.isShutdown();
    }

    @Override
    public boolean isShuttingDown() {
        return this.connectionManager.isShuttingDown();
    }

    @Override
    public <K, V> RMapCacheReactive<K, V> getMapCache(String name, Codec codec, MapOptions<K, V> options) {
        RedissonMapCache<K, V> map = new RedissonMapCache<K, V>(codec, this.evictionScheduler, this.commandExecutor, name, null, options, this.writeBehindService);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheReactive<K, V>(map, this.commandExecutor), RMapCacheReactive.class);
    }

    @Override
    public <K, V> RMapCacheReactive<K, V> getMapCache(String name, MapOptions<K, V> options) {
        RedissonMapCache<K, V> map = new RedissonMapCache<K, V>(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name, null, options, this.writeBehindService);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheReactive<K, V>(map, this.commandExecutor), RMapCacheReactive.class);
    }

    @Override
    public <K, V> RMapReactive<K, V> getMap(String name, MapOptions<K, V> options) {
        RedissonMap<K, V> map = new RedissonMap<K, V>(this.commandExecutor, name, null, options, this.writeBehindService);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapReactive<K, V>(map, this.commandExecutor), RMapReactive.class);
    }

    @Override
    public <K, V> RMapReactive<K, V> getMap(String name, Codec codec, MapOptions<K, V> options) {
        RedissonMap<K, V> map = new RedissonMap<K, V>(codec, this.commandExecutor, name, null, options, this.writeBehindService);
        return ReactiveProxyBuilder.create(this.commandExecutor, map, new RedissonMapReactive<K, V>(map, this.commandExecutor), RMapReactive.class);
    }

    @Override
    public RTransactionReactive createTransaction(TransactionOptions options) {
        return new RedissonTransactionReactive(this.commandExecutor, options);
    }

    @Override
    public <V> RBlockingDequeReactive<V> getBlockingDeque(String name) {
        RedissonBlockingDeque deque = new RedissonBlockingDeque(this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, deque, new RedissonBlockingDequeReactive(deque), RBlockingDequeReactive.class);
    }

    @Override
    public <V> RBlockingDequeReactive<V> getBlockingDeque(String name, Codec codec) {
        RedissonBlockingDeque deque = new RedissonBlockingDeque(codec, this.commandExecutor, name, null);
        return ReactiveProxyBuilder.create(this.commandExecutor, deque, new RedissonBlockingDequeReactive(deque), RBlockingDequeReactive.class);
    }

    @Override
    public <V> RTransferQueueReactive<V> getTransferQueue(String name) {
        String remoteName = RedissonObject.suffixName(name, "remoteService");
        RRemoteService service = this.getRemoteService(remoteName);
        RedissonTransferQueue queue = new RedissonTransferQueue(this.commandExecutor, name, service);
        return ReactiveProxyBuilder.create(this.commandExecutor, queue, new RedissonTransferQueueReactive(queue), RTransferQueueReactive.class);
    }

    @Override
    public <V> RTransferQueueReactive<V> getTransferQueue(String name, Codec codec) {
        String remoteName = RedissonObject.suffixName(name, "remoteService");
        RRemoteService service = this.getRemoteService(remoteName);
        RedissonTransferQueue queue = new RedissonTransferQueue(codec, this.commandExecutor, name, service);
        return ReactiveProxyBuilder.create(this.commandExecutor, queue, new RedissonTransferQueueReactive(queue), RTransferQueueReactive.class);
    }

    @Override
    public String getId() {
        return this.commandExecutor.getConnectionManager().getId();
    }
}

