/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonSetCache;
import org.redisson.api.RCollectionAsync;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RSetCache;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.BaseTransactionalSet;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.set.AddCacheOperation;
import org.redisson.transaction.operation.set.MoveOperation;
import org.redisson.transaction.operation.set.RemoveCacheOperation;

public class TransactionalSetCache<V>
extends BaseTransactionalSet<V> {
    private final RSetCache<V> set;
    private final String transactionId;

    public TransactionalSetCache(CommandAsyncExecutor commandExecutor, long timeout, List<TransactionalOperation> operations, RSetCache<V> set, String transactionId) {
        super(commandExecutor, timeout, operations, set);
        this.set = set;
        this.transactionId = transactionId;
    }

    @Override
    protected ListScanResult<Object> scanIteratorSource(String name, RedisClient client, long startPos, String pattern, int count) {
        return ((RedissonSetCache)this.set).scanIterator(name, client, startPos, pattern, count);
    }

    @Override
    protected RFuture<Set<V>> readAllAsyncSource() {
        return this.set.readAllAsync();
    }

    public RFuture<Boolean> addAsync(V value, long ttl, TimeUnit ttlUnit) {
        long threadId = Thread.currentThread().getId();
        return this.addAsync(value, new AddCacheOperation(this.set, value, ttl, ttlUnit, this.transactionId, threadId));
    }

    @Override
    protected TransactionalOperation createAddOperation(V value, long threadId) {
        return new AddCacheOperation(this.set, value, this.transactionId, threadId);
    }

    @Override
    protected MoveOperation createMoveOperation(String destination, V value, long threadId) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected TransactionalOperation createRemoveOperation(Object value, long threadId) {
        return new RemoveCacheOperation(this.set, value, this.transactionId, threadId);
    }

    @Override
    protected RLock getLock(RCollectionAsync<V> set, V value) {
        String lockName = ((RedissonSetCache)set).getLockByValue(value, "lock");
        return new RedissonTransactionalLock(this.commandExecutor, lockName, this.transactionId);
    }
}

