/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.resolver;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.liveobject.resolver.AbstractNamingScheme;
import org.redisson.liveobject.resolver.NamingScheme;

public class DefaultNamingScheme
extends AbstractNamingScheme
implements NamingScheme {
    public DefaultNamingScheme(Codec codec) {
        super(codec);
    }

    @Override
    public String getNamePattern(Class<?> entityClass, Class<?> idFieldClass, String idFieldName) {
        return "redisson_live_object:{*}:" + entityClass.getName() + ":" + idFieldName + ":" + idFieldClass.getName();
    }

    @Override
    public String getName(Class<?> entityClass, Class<?> idFieldClass, String idFieldName, Object idValue) {
        try {
            String encode = DefaultNamingScheme.bytesToHex(this.codec.getMapKeyEncoder().encode(idValue));
            return "redisson_live_object:{" + encode + "}:" + entityClass.getName() + ":" + idFieldName + ":" + idFieldClass.getName();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to encode \"" + idFieldName + "\" [" + idValue + "] into byte[]", ex);
        }
    }

    @Override
    public String getFieldReferenceName(Class<?> entityClass, Object idValue, Class<?> fieldClass, String fieldName, Object fieldValue) {
        try {
            String encode = DefaultNamingScheme.bytesToHex(this.codec.getMapKeyEncoder().encode(idValue));
            return "redisson_live_object_field:{" + encode + "}:" + entityClass.getName() + ":" + fieldName + ":" + fieldClass.getName();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to encode \"" + fieldName + "\" [" + fieldValue + "] into byte[]", ex);
        }
    }

    @Override
    public Object resolveId(String name) {
        String decode = name.substring(name.indexOf("{") + 1, name.indexOf("}"));
        ByteBuf b = Unpooled.wrappedBuffer((byte[])ByteBufUtil.decodeHexDump((CharSequence)decode));
        try {
            Object object = this.codec.getMapKeyDecoder().decode(b, new State());
            return object;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to decode [" + decode + "] into object", ex);
        }
        finally {
            b.release();
        }
    }

    private static String bytesToHex(ByteBuf bytes) {
        try {
            String string = ByteBufUtil.hexDump((ByteBuf)bytes);
            return string;
        }
        finally {
            bytes.release();
        }
    }

    @Override
    public String getIndexName(Class<?> entityClass, String fieldName) {
        return "redisson_live_object_index:{" + entityClass.getName() + "}:" + fieldName;
    }
}

