/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.description.field.FieldDescription;
import org.redisson.RedissonBlockingDeque;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonDeque;
import org.redisson.RedissonList;
import org.redisson.RedissonLiveObjectService;
import org.redisson.RedissonMap;
import org.redisson.RedissonQueue;
import org.redisson.RedissonReference;
import org.redisson.RedissonSet;
import org.redisson.RedissonSortedSet;
import org.redisson.api.RLiveObject;
import org.redisson.api.RMap;
import org.redisson.api.RObject;
import org.redisson.api.RObjectReactive;
import org.redisson.api.RObjectRx;
import org.redisson.api.RedissonClient;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.api.RedissonRxClient;
import org.redisson.api.annotation.REntity;
import org.redisson.api.annotation.RId;
import org.redisson.api.annotation.RObjectField;
import org.redisson.client.codec.Codec;
import org.redisson.codec.DefaultReferenceCodecProvider;
import org.redisson.codec.ReferenceCodecProvider;
import org.redisson.config.Config;
import org.redisson.liveobject.misc.ClassUtils;
import org.redisson.liveobject.misc.Introspectior;
import org.redisson.liveobject.resolver.NamingScheme;

public class RedissonObjectBuilder {
    private static final Map<Class<?>, Class<? extends RObject>> SUPPORTED_CLASS_MAPPING = new LinkedHashMap();
    private static final Map<Class<?>, CodecMethodRef> REFERENCES = new HashMap();
    private final Config config;
    private final RedissonClient redisson;
    private final RedissonReactiveClient redissonReactive;
    private final RedissonRxClient redissonRx;
    private final ReferenceCodecProvider codecProvider = new DefaultReferenceCodecProvider();

    public RedissonObjectBuilder(Config config, RedissonClient redisson, RedissonReactiveClient redissonReactive, RedissonRxClient redissonRx) {
        this.config = config;
        this.redisson = redisson;
        this.redissonReactive = redissonReactive;
        this.redissonRx = redissonRx;
    }

    public ReferenceCodecProvider getReferenceCodecProvider() {
        return this.codecProvider;
    }

    public void storeAsync(RObject ar, String fieldName, RMap<String, Object> liveMap) {
        Codec codec = ar.getCodec();
        if (codec != null) {
            this.codecProvider.registerCodec(codec.getClass(), codec);
        }
        liveMap.fastPutAsync(fieldName, new RedissonReference(ar.getClass(), ar.getName(), codec));
    }

    public void store(RObject ar, String fieldName, RMap<String, Object> liveMap) {
        Codec codec = ar.getCodec();
        if (codec != null) {
            this.codecProvider.registerCodec(codec.getClass(), codec);
        }
        liveMap.fastPut(fieldName, new RedissonReference(ar.getClass(), ar.getName(), codec));
    }

    public RObject createObject(Object id, Class<?> clazz, Class<?> fieldType, String fieldName) {
        Class<? extends RObject> mappedClass = this.getMappedClass(fieldType);
        try {
            if (mappedClass != null) {
                Codec fieldCodec = this.getFieldCodec(clazz, mappedClass, fieldName);
                NamingScheme fieldNamingScheme = this.getNamingScheme(clazz, fieldCodec);
                String referenceName = fieldNamingScheme.getFieldReferenceName(clazz, id, mappedClass, fieldName, null);
                return this.createRObject(this.redisson, mappedClass, referenceName, fieldCodec);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return null;
    }

    private Codec getFieldCodec(Class<?> rEntity, Class<? extends RObject> rObjectClass, String fieldName) throws ReflectiveOperationException {
        Field field = ClassUtils.getDeclaredField(rEntity, fieldName);
        if (field.isAnnotationPresent(RObjectField.class)) {
            RObjectField anno = field.getAnnotation(RObjectField.class);
            return this.codecProvider.getCodec(anno, rEntity, rObjectClass, fieldName, this.config);
        }
        REntity anno = ClassUtils.getAnnotation(rEntity, REntity.class);
        return this.codecProvider.getCodec(anno, rEntity, this.config);
    }

    public NamingScheme getNamingScheme(Class<?> entityClass) {
        REntity anno = ClassUtils.getAnnotation(entityClass, REntity.class);
        Object codec = this.codecProvider.getCodec(anno, entityClass, this.config);
        return this.getNamingScheme(entityClass, (Codec)codec);
    }

    public NamingScheme getNamingScheme(Class<?> rEntity, Codec c) {
        REntity anno = ClassUtils.getAnnotation(rEntity, REntity.class);
        try {
            return anno.namingScheme().getDeclaredConstructor(Codec.class).newInstance(c);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Class<? extends RObject> getMappedClass(Class<?> cls) {
        for (Map.Entry<Class<?>, Class<RObject>> entrySet : SUPPORTED_CLASS_MAPPING.entrySet()) {
            if (!entrySet.getKey().isAssignableFrom(cls)) continue;
            return entrySet.getValue();
        }
        return null;
    }

    private static void fillCodecMethods(Map<Class<?>, CodecMethodRef> map, Class<?> clientClazz, Class<?> objectClazz) {
        for (Method method : clientClazz.getDeclaredMethods()) {
            if (method.getReturnType().equals(Void.TYPE) || !objectClazz.isAssignableFrom(method.getReturnType()) || !method.getName().startsWith("get")) continue;
            Class<?> cls = method.getReturnType();
            if (!map.containsKey(cls)) {
                map.put(cls, new CodecMethodRef());
            }
            CodecMethodRef builder = map.get(cls);
            if (method.getParameterTypes().length == 2 && Codec.class.isAssignableFrom(method.getParameterTypes()[1])) {
                builder.customCodecMethod = method;
                continue;
            }
            if (method.getParameterTypes().length != 1) continue;
            builder.defaultCodecMethod = method;
        }
    }

    public Object fromReference(RedissonReference rr) throws ReflectiveOperationException {
        if (this.redisson != null) {
            return this.fromReference(this.redisson, rr);
        }
        if (this.redissonReactive != null) {
            return this.fromReference(this.redissonReactive, rr);
        }
        if (this.redissonRx != null) {
            return this.fromReference(this.redissonRx, rr);
        }
        throw new IllegalStateException();
    }

    private Object fromReference(RedissonClient redisson, RedissonReference rr) throws ReflectiveOperationException {
        Class<?> type = rr.getType();
        if (type != null && ClassUtils.isAnnotationPresent(type, REntity.class)) {
            RedissonLiveObjectService liveObjectService = (RedissonLiveObjectService)redisson.getLiveObjectService();
            NamingScheme ns = this.getNamingScheme(type);
            Object id = ns.resolveId(rr.getKeyName());
            return liveObjectService.createLiveObject(type, id);
        }
        return this.getObject(redisson, rr, type, this.codecProvider);
    }

    private Object getObject(Object redisson, RedissonReference rr, Class<? extends Object> type, ReferenceCodecProvider codecProvider) throws ReflectiveOperationException {
        if (type != null) {
            CodecMethodRef b = REFERENCES.get(type);
            if (b == null && type.getInterfaces().length > 0) {
                type = type.getInterfaces()[0];
            }
            if ((b = REFERENCES.get(type)) != null) {
                Method builder = b.get(this.isDefaultCodec(rr));
                if (this.isDefaultCodec(rr)) {
                    return builder.invoke(redisson, rr.getKeyName());
                }
                return builder.invoke(redisson, rr.getKeyName(), codecProvider.getCodec(rr.getCodecType()));
            }
        }
        throw new ClassNotFoundException("No RObject is found to match class type of " + rr.getTypeName() + " with codec type of " + rr.getCodecName());
    }

    private boolean isDefaultCodec(RedissonReference rr) {
        return rr.getCodec() == null;
    }

    private Object fromReference(RedissonRxClient redisson, RedissonReference rr) throws ReflectiveOperationException {
        Class<?> type = rr.getReactiveType();
        return this.getObject(redisson, rr, type, this.codecProvider);
    }

    private Object fromReference(RedissonReactiveClient redisson, RedissonReference rr) throws ReflectiveOperationException {
        Class<?> type = rr.getReactiveType();
        return this.getObject(redisson, rr, type, this.codecProvider);
    }

    public RedissonReference toReference(Object object) {
        if (object != null && ClassUtils.isAnnotationPresent(object.getClass(), REntity.class)) {
            throw new IllegalArgumentException("REntity should be attached to Redisson before save");
        }
        if (object instanceof RObject && !(object instanceof RLiveObject)) {
            Class<?> clazz = object.getClass().getInterfaces()[0];
            RObject rObject = (RObject)object;
            if (rObject.getCodec() != null) {
                this.codecProvider.registerCodec(rObject.getCodec().getClass(), rObject.getCodec());
            }
            return new RedissonReference(clazz, rObject.getName(), rObject.getCodec());
        }
        if (object instanceof RObjectReactive && !(object instanceof RLiveObject)) {
            Class<?> clazz = object.getClass().getInterfaces()[0];
            RObjectReactive rObject = (RObjectReactive)object;
            if (rObject.getCodec() != null) {
                this.codecProvider.registerCodec(rObject.getCodec().getClass(), rObject.getCodec());
            }
            return new RedissonReference(clazz, rObject.getName(), rObject.getCodec());
        }
        try {
            if (object instanceof RLiveObject) {
                Class<?> rEntity = object.getClass().getSuperclass();
                NamingScheme ns = this.getNamingScheme(rEntity);
                String name = ((FieldDescription.InDefinedShape)Introspectior.getFieldsWithAnnotation(rEntity, RId.class).getOnly()).getName();
                Class<?> type = ClassUtils.getDeclaredField(rEntity, name).getType();
                return new RedissonReference(rEntity, ns.getName(rEntity, type, name, ((RLiveObject)object).getLiveObjectId()));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return null;
    }

    private <T extends RObject, K extends Codec> T createRObject(RedissonClient redisson, Class<T> expectedType, String name, K codec) throws ReflectiveOperationException {
        List<Class<?>> interfaces = Arrays.asList(expectedType.getInterfaces());
        for (Class<?> iType : interfaces) {
            if (!REFERENCES.containsKey(iType)) continue;
            Method builder = REFERENCES.get(iType).get(codec != null);
            if (codec != null) {
                return (T)((RObject)builder.invoke((Object)redisson, name));
            }
            return (T)((RObject)builder.invoke((Object)redisson, name, codec));
        }
        String type = null;
        if (expectedType != null) {
            type = expectedType.getName();
        }
        String codecName = null;
        if (codec != null) {
            codecName = codec.getClass().getName();
        }
        throw new ClassNotFoundException("No RObject is found to match class type of " + type + " with codec type of " + codecName);
    }

    static {
        SUPPORTED_CLASS_MAPPING.put(SortedSet.class, RedissonSortedSet.class);
        SUPPORTED_CLASS_MAPPING.put(Set.class, RedissonSet.class);
        SUPPORTED_CLASS_MAPPING.put(ConcurrentMap.class, RedissonMap.class);
        SUPPORTED_CLASS_MAPPING.put(Map.class, RedissonMap.class);
        SUPPORTED_CLASS_MAPPING.put(BlockingDeque.class, RedissonBlockingDeque.class);
        SUPPORTED_CLASS_MAPPING.put(Deque.class, RedissonDeque.class);
        SUPPORTED_CLASS_MAPPING.put(BlockingQueue.class, RedissonBlockingQueue.class);
        SUPPORTED_CLASS_MAPPING.put(Queue.class, RedissonQueue.class);
        SUPPORTED_CLASS_MAPPING.put(List.class, RedissonList.class);
        RedissonObjectBuilder.fillCodecMethods(REFERENCES, RedissonClient.class, RObject.class);
        RedissonObjectBuilder.fillCodecMethods(REFERENCES, RedissonReactiveClient.class, RObjectReactive.class);
        RedissonObjectBuilder.fillCodecMethods(REFERENCES, RedissonRxClient.class, RObjectRx.class);
    }

    public static class CodecMethodRef {
        Method defaultCodecMethod;
        Method customCodecMethod;

        Method get(boolean value) {
            if (value) {
                return this.defaultCodecMethod;
            }
            return this.customCodecMethod;
        }
    }
}

