/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.IOException;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.marshalling.Unmarshaller;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class MarshallingCodec
extends BaseCodec {
    private final FastThreadLocal<Unmarshaller> decoderThreadLocal = new FastThreadLocal<Unmarshaller>(){

        protected Unmarshaller initialValue() throws IOException {
            return MarshallingCodec.this.factory.createUnmarshaller(MarshallingCodec.this.configuration);
        }
    };
    private final FastThreadLocal<Marshaller> encoderThreadLocal = new FastThreadLocal<Marshaller>(){

        protected Marshaller initialValue() throws IOException {
            return MarshallingCodec.this.factory.createMarshaller(MarshallingCodec.this.configuration);
        }
    };
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            Unmarshaller unmarshaller = (Unmarshaller)MarshallingCodec.this.decoderThreadLocal.get();
            try {
                unmarshaller.start((ByteInput)new ByteInputWrapper(buf));
                Object object = unmarshaller.readObject();
                return object;
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            finally {
                unmarshaller.finish();
                unmarshaller.close();
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            Marshaller marshaller = (Marshaller)MarshallingCodec.this.encoderThreadLocal.get();
            try {
                marshaller.start((ByteOutput)new ByteOutputWrapper(out));
                marshaller.writeObject(in);
            }
            finally {
                marshaller.finish();
                marshaller.close();
            }
            return out;
        }
    };
    private final MarshallerFactory factory;
    private final MarshallingConfiguration configuration;
    private ClassLoader classLoader;

    protected MarshallingConfiguration createConfig() {
        MarshallingConfiguration config = new MarshallingConfiguration();
        config.setInstanceCount(32);
        config.setClassCount(16);
        return config;
    }

    public MarshallingCodec() {
        this(Protocol.RIVER, null);
    }

    public MarshallingCodec(ClassLoader classLoader) {
        this(Protocol.RIVER, null);
        this.configuration.setClassResolver((ClassResolver)new SimpleClassResolver(classLoader));
        this.classLoader = classLoader;
    }

    public MarshallingCodec(ClassLoader classLoader, MarshallingCodec codec) {
        this.factory = codec.factory;
        this.configuration = codec.configuration;
        this.configuration.setClassResolver((ClassResolver)new SimpleClassResolver(classLoader));
        this.classLoader = classLoader;
    }

    public MarshallingCodec(Protocol protocol, MarshallingConfiguration configuration) {
        this.factory = Marshalling.getProvidedMarshallerFactory((String)protocol.toString().toLowerCase());
        if (this.factory == null) {
            throw new IllegalArgumentException(protocol.toString());
        }
        if (configuration == null) {
            configuration = this.createConfig();
        }
        this.configuration = configuration;
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return super.getClassLoader();
    }

    public static enum Protocol {
        SERIAL,
        RIVER;

    }

    public static class ByteOutputWrapper
    implements ByteOutput {
        private final ByteBuf byteBuf;

        public ByteOutputWrapper(ByteBuf byteBuf) {
            this.byteBuf = byteBuf;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(int b) throws IOException {
            this.byteBuf.writeByte(b);
        }

        public void write(byte[] b) throws IOException {
            this.byteBuf.writeBytes(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.byteBuf.writeBytes(b, off, len);
        }
    }

    public static class ByteInputWrapper
    implements ByteInput {
        private final ByteBuf byteBuf;

        public ByteInputWrapper(ByteBuf byteBuf) {
            this.byteBuf = byteBuf;
        }

        public void close() throws IOException {
        }

        public int read() throws IOException {
            return this.byteBuf.readByte() & 0xFF;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int length = this.available();
            int readLength = Math.min(len, length);
            this.byteBuf.readBytes(b, off, readLength);
            return readLength;
        }

        public int available() throws IOException {
            return this.byteBuf.readableBytes();
        }

        public long skip(long n) throws IOException {
            int length = this.available();
            long skipLength = Math.min((long)length, n);
            this.byteBuf.readerIndex((int)((long)this.byteBuf.readerIndex() + skipLength));
            return skipLength;
        }
    }
}

