/**
 * Copyright (c) 2013-2019 Nikita Koksharov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.redisson.transaction.operation.map;

import org.redisson.api.RMap;

/**
 * 
 * @author Nikita Koksharov
 *
 */
public class MapPutOperation extends MapOperation {

    public MapPutOperation() {
    }
    
    public MapPutOperation(RMap<?, ?> map, Object key, Object value, String transactionId) {
        super(map, key, value, transactionId);
    }

    @Override
    public void commit(RMap<Object, Object> map) {
        map.putAsync(key, value);
    }
    
}
