/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch;

import com.facebook.jni.annotations.DoNotStrip;
import java.util.Locale;
import java.util.Map;
import org.pytorch.Tensor;

@DoNotStrip
public class IValue {
    private static final int TYPE_CODE_NULL = 1;
    private static final int TYPE_CODE_TENSOR = 2;
    private static final int TYPE_CODE_BOOL = 3;
    private static final int TYPE_CODE_LONG = 4;
    private static final int TYPE_CODE_DOUBLE = 5;
    private static final int TYPE_CODE_STRING = 6;
    private static final int TYPE_CODE_TUPLE = 7;
    private static final int TYPE_CODE_BOOL_LIST = 8;
    private static final int TYPE_CODE_LONG_LIST = 9;
    private static final int TYPE_CODE_DOUBLE_LIST = 10;
    private static final int TYPE_CODE_TENSOR_LIST = 11;
    private static final int TYPE_CODE_LIST = 12;
    private static final int TYPE_CODE_DICT_STRING_KEY = 13;
    private static final int TYPE_CODE_DICT_LONG_KEY = 14;
    private String[] TYPE_NAMES = new String[]{"Unknown", "Null", "Tensor", "Bool", "Long", "Double", "String", "Tuple", "BoolList", "LongList", "DoubleList", "TensorList", "GenericList", "DictStringKey", "DictLongKey"};
    @DoNotStrip
    private final int mTypeCode;
    @DoNotStrip
    private Object mData;

    @DoNotStrip
    private IValue(int typeCode) {
        this.mTypeCode = typeCode;
    }

    @DoNotStrip
    public boolean isNull() {
        return 1 == this.mTypeCode;
    }

    @DoNotStrip
    public boolean isTensor() {
        return 2 == this.mTypeCode;
    }

    @DoNotStrip
    public boolean isBool() {
        return 3 == this.mTypeCode;
    }

    @DoNotStrip
    public boolean isLong() {
        return 4 == this.mTypeCode;
    }

    @DoNotStrip
    public boolean isDouble() {
        return 5 == this.mTypeCode;
    }

    @DoNotStrip
    public boolean isString() {
        return 6 == this.mTypeCode;
    }

    @DoNotStrip
    public boolean isTuple() {
        return 7 == this.mTypeCode;
    }

    @DoNotStrip
    public boolean isBoolList() {
        return 8 == this.mTypeCode;
    }

    @DoNotStrip
    public boolean isLongList() {
        return 9 == this.mTypeCode;
    }

    @DoNotStrip
    public boolean isDoubleList() {
        return 10 == this.mTypeCode;
    }

    @DoNotStrip
    public boolean isTensorList() {
        return 11 == this.mTypeCode;
    }

    @DoNotStrip
    public boolean isList() {
        return 12 == this.mTypeCode;
    }

    @DoNotStrip
    public boolean isDictStringKey() {
        return 13 == this.mTypeCode;
    }

    @DoNotStrip
    public boolean isDictLongKey() {
        return 14 == this.mTypeCode;
    }

    @DoNotStrip
    public static IValue optionalNull() {
        return new IValue(1);
    }

    @DoNotStrip
    public static IValue from(Tensor tensor) {
        IValue iv = new IValue(2);
        iv.mData = tensor;
        return iv;
    }

    @DoNotStrip
    public static IValue from(boolean value) {
        IValue iv = new IValue(3);
        iv.mData = value;
        return iv;
    }

    @DoNotStrip
    public static IValue from(long value) {
        IValue iv = new IValue(4);
        iv.mData = value;
        return iv;
    }

    @DoNotStrip
    public static IValue from(double value) {
        IValue iv = new IValue(5);
        iv.mData = value;
        return iv;
    }

    @DoNotStrip
    public static IValue from(String value) {
        IValue iv = new IValue(6);
        iv.mData = value;
        return iv;
    }

    @DoNotStrip
    public static IValue listFrom(boolean ... list) {
        IValue iv = new IValue(8);
        iv.mData = list;
        return iv;
    }

    @DoNotStrip
    public static IValue listFrom(long ... list) {
        IValue iv = new IValue(9);
        iv.mData = list;
        return iv;
    }

    @DoNotStrip
    public static IValue listFrom(double ... list) {
        IValue iv = new IValue(10);
        iv.mData = list;
        return iv;
    }

    @DoNotStrip
    public static IValue listFrom(Tensor ... list) {
        IValue iv = new IValue(11);
        iv.mData = list;
        return iv;
    }

    @DoNotStrip
    public static IValue listFrom(IValue ... array) {
        int size = array.length;
        if (size > 0) {
            int typeCode0 = array[0].mTypeCode;
            for (int i = 1; i < size; ++i) {
                if (typeCode0 == array[i].mTypeCode) continue;
                throw new IllegalArgumentException("List must contain items of the same type");
            }
        }
        IValue iv = new IValue(12);
        iv.mData = array;
        return iv;
    }

    @DoNotStrip
    public static IValue tupleFrom(IValue ... array) {
        IValue iv = new IValue(7);
        iv.mData = array;
        return iv;
    }

    @DoNotStrip
    public static IValue dictStringKeyFrom(Map<String, IValue> map) {
        IValue iv = new IValue(13);
        iv.mData = map;
        return iv;
    }

    @DoNotStrip
    public static IValue dictLongKeyFrom(Map<Long, IValue> map) {
        IValue iv = new IValue(14);
        iv.mData = map;
        return iv;
    }

    @DoNotStrip
    public Tensor toTensor() {
        this.preconditionType(2, this.mTypeCode);
        return (Tensor)this.mData;
    }

    @DoNotStrip
    public boolean toBool() {
        this.preconditionType(3, this.mTypeCode);
        return (Boolean)this.mData;
    }

    @DoNotStrip
    public long toLong() {
        this.preconditionType(4, this.mTypeCode);
        return (Long)this.mData;
    }

    @DoNotStrip
    public double toDouble() {
        this.preconditionType(5, this.mTypeCode);
        return (Double)this.mData;
    }

    @DoNotStrip
    public String toStr() {
        this.preconditionType(6, this.mTypeCode);
        return (String)this.mData;
    }

    @DoNotStrip
    public boolean[] toBoolList() {
        this.preconditionType(8, this.mTypeCode);
        return (boolean[])this.mData;
    }

    @DoNotStrip
    public long[] toLongList() {
        this.preconditionType(9, this.mTypeCode);
        return (long[])this.mData;
    }

    @DoNotStrip
    public double[] toDoubleList() {
        this.preconditionType(10, this.mTypeCode);
        return (double[])this.mData;
    }

    @DoNotStrip
    public Tensor[] toTensorList() {
        this.preconditionType(11, this.mTypeCode);
        return (Tensor[])this.mData;
    }

    @DoNotStrip
    public IValue[] toList() {
        this.preconditionType(12, this.mTypeCode);
        return (IValue[])this.mData;
    }

    @DoNotStrip
    public IValue[] toTuple() {
        this.preconditionType(7, this.mTypeCode);
        return (IValue[])this.mData;
    }

    @DoNotStrip
    public Map<String, IValue> toDictStringKey() {
        this.preconditionType(13, this.mTypeCode);
        return (Map)this.mData;
    }

    @DoNotStrip
    public Map<Long, IValue> toDictLongKey() {
        this.preconditionType(14, this.mTypeCode);
        return (Map)this.mData;
    }

    private void preconditionType(int typeCodeExpected, int typeCode) {
        if (typeCode != typeCodeExpected) {
            throw new IllegalStateException(String.format(Locale.US, "Expected IValue type %s, actual type %s", this.getTypeName(typeCodeExpected), this.getTypeName(typeCode)));
        }
    }

    private String getTypeName(int typeCode) {
        return typeCode >= 0 && typeCode < this.TYPE_NAMES.length ? this.TYPE_NAMES[typeCode] : "Unknown";
    }
}

