/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.vicino;

import edu.mit.simile.vicino.Operator;
import edu.mit.simile.vicino.distances.Distance;
import java.util.List;

public class Distributor
extends Operator {
    private static final int COLUMNS = 70;
    private static final char CHAR = '=';

    public static void main(String[] args) throws Exception {
        int i;
        Distance d = Distributor.getDistance(args[0]);
        List<String> strings = Distributor.getStrings(args[1]);
        int buckets = Integer.parseInt(args[2]);
        long start = System.currentTimeMillis();
        int[] values = new int[buckets];
        int size = strings.size();
        for (int i2 = 0; i2 < size; ++i2) {
            int dist;
            String x = strings.get((int)(Math.random() * (double)size));
            String y = strings.get((int)(Math.random() * (double)size));
            int n = dist = (int)((double)buckets * d.d(x, y));
            values[n] = values[n] + 1;
            System.out.print(".");
        }
        System.out.println();
        long stop = System.currentTimeMillis();
        float m = (float)(stop - start) / (float)size;
        int maxValue = 0;
        for (i = 0; i < buckets; ++i) {
            if (values[i] <= maxValue) continue;
            maxValue = values[i];
        }
        System.out.println("+-------------------------------------------------------------------");
        for (i = 0; i < buckets; ++i) {
            System.out.println("|" + Distributor.bar(70 * values[i] / maxValue));
        }
        System.out.println("+-------------------------------------------------------------------");
        System.out.println("\n Each distance calculation took: " + m + " millis");
    }

    private static String bar(int value) {
        StringBuffer b = new StringBuffer(value);
        for (int i = 0; i < value; ++i) {
            b.append('=');
        }
        return b.toString();
    }
}

