/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.butterfly.velocity;

import edu.mit.simile.butterfly.ButterflyModule;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ButterflyResourceLoader
extends FileResourceLoader {
    private static final Logger _logger = LoggerFactory.getLogger((String)"butterfly.resource_loader");
    private ButterflyModule _module;

    public void commonInit(RuntimeServices rs, ExtendedProperties configuration) {
        super.commonInit(rs, configuration);
        Object o = rs.getApplicationAttribute((Object)"module");
        if (o == null) {
            throw new RuntimeException("The ButterflyResourceLoader couldn't find an instance to the module!");
        }
        this._module = (ButterflyModule)o;
    }

    public synchronized InputStream getResourceStream(String name) throws ResourceNotFoundException {
        InputStream result = null;
        if (name == null || name.length() == 0) {
            throw new ResourceNotFoundException("No template name provided");
        }
        URL url = this.getResource(name);
        if (url != null) {
            try {
                result = url.openStream();
            }
            catch (Exception e) {
                _logger.error("Error opening stream", (Throwable)e);
                throw new ResourceNotFoundException(e.getMessage());
            }
        } else {
            throw new ResourceNotFoundException("Resource '" + name + "' count not be found");
        }
        return result;
    }

    public boolean isSourceModified(Resource resource) {
        return this.getLastModified(resource) > resource.getLastModified();
    }

    public long getLastModified(Resource resource) {
        long result = Long.MAX_VALUE;
        try {
            URLConnection c = this.getResource(resource.getName()).openConnection();
            result = c.getLastModified();
        }
        catch (Exception e) {
            _logger.error("Error opening connection", (Throwable)e);
        }
        return result;
    }

    private URL getResource(String name) {
        return this._module.getResource(name);
    }
}

