/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.arithcode.ppm;

import com.colloquial.arithcode.ppm.ByteSet;
import java.util.Arrays;

final class ExcludingAdaptiveUnigramModel {
    private int[] _count = new int[257];
    private static final int MAX_INDIVIDUAL_COUNT = 8192;
    private static final int EOF_INDEX = 256;

    public ExcludingAdaptiveUnigramModel() {
        Arrays.fill(this._count, 1);
    }

    public void interval(int symbol, int[] result, ByteSet exclusions) {
        int i;
        if (symbol == -1) {
            symbol = 256;
        }
        int sum = 0;
        for (i = 0; i < symbol; ++i) {
            if (exclusions.contains(i)) continue;
            sum += this._count[i];
        }
        result[0] = sum;
        result[1] = sum += this._count[symbol];
        for (i = symbol + 1; i < this._count.length - 1; ++i) {
            if (exclusions.contains(i)) continue;
            sum += this._count[i];
        }
        if (symbol != 256) {
            sum += this._count[256];
        }
        result[2] = sum;
        this.increment(symbol);
    }

    public int pointToSymbol(int midCount, ByteSet exclusions) {
        int sum = 0;
        int mid = 0;
        while (mid != 256 && exclusions.contains(mid) || (sum += this._count[mid]) <= midCount) {
            ++mid;
        }
        return mid == 256 ? -1 : mid;
    }

    public int totalCount(ByteSet exclusions) {
        int total = 0;
        for (int i = 0; i < this._count.length; ++i) {
            if (i != 256 && exclusions.contains(i)) continue;
            total += this._count[i];
        }
        return total;
    }

    public void increment(int i) {
        int n = i;
        this._count[n] = this._count[n] + 1;
        if (this._count[n] > 8192) {
            this.rescale();
        }
    }

    private void rescale() {
        for (int i = 0; i < this._count.length; ++i) {
            this._count[i] = (this._count[i] + 1) / 2;
        }
    }
}

