/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.arithcode.demo;

import com.colloquial.arithcode.ppm.AdaptiveUnigramModel;
import com.colloquial.arithcode.ppm.ArithCodeInputStream;
import com.colloquial.arithcode.ppm.ArithCodeModel;
import com.colloquial.arithcode.ppm.ArithCodeOutputStream;
import com.colloquial.arithcode.ppm.PPMModel;
import com.colloquial.arithcode.ppm.UniformModel;
import com.colloquial.io.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class CalgaryDemo {
    public static void main(String[] args) throws IOException {
        File corpusDir = new File(args[0]);
        for (File file : corpusDir.listFiles()) {
            CalgaryDemo.demo(file);
        }
    }

    public static void demo(File file) throws IOException {
        if (file.getName().startsWith(".")) {
            return;
        }
        byte[] bytes = Util.readBytes(file);
        System.out.println("\nFILE=" + file + " #bytes=" + bytes.length);
        CalgaryDemo.demo(bytes, UniformModel.MODEL, UniformModel.MODEL);
        CalgaryDemo.demo(bytes, new AdaptiveUnigramModel(), new AdaptiveUnigramModel());
        for (int n = 0; n <= 16; n += n > 7 ? 2 : 1) {
            CalgaryDemo.demo(bytes, new PPMModel(n), new PPMModel(n));
        }
    }

    public static void demo(byte[] bytes, ArithCodeModel modelEncode, ArithCodeModel modelDecode) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArithCodeOutputStream encoder = new ArithCodeOutputStream(out, modelEncode);
        long startTime = System.currentTimeMillis();
        ((OutputStream)encoder).write(bytes, 0, bytes.length);
        ((OutputStream)encoder).close();
        long endTime = System.currentTimeMillis();
        double encodeTime = (double)(endTime - startTime) / 10000.0;
        byte[] encodedBytes = out.toByteArray();
        ByteArrayInputStream encodedBytesIn = new ByteArrayInputStream(encodedBytes);
        ArithCodeInputStream decodedBytesIn = new ArithCodeInputStream(encodedBytesIn, modelDecode);
        ByteArrayOutputStream decodedBytesOut = new ByteArrayOutputStream();
        startTime = System.currentTimeMillis();
        Util.copy(decodedBytesIn, decodedBytesOut);
        endTime = System.currentTimeMillis();
        double decodeTime = (double)(endTime - startTime) / 10000.0;
        System.out.printf("%20s  enc=%6.1f MB/s   dec=%6.1f MB/s   comp= %5.3f b/B\n", modelEncode.toString(), (double)bytes.length / encodeTime / 1000000.0, (double)bytes.length / decodeTime / 1000000.0, 8.0 * (double)encodedBytes.length / (double)bytes.length);
        byte[] decodedBytes = decodedBytesOut.toByteArray();
        if (!Arrays.equals(bytes, decodedBytes)) {
            System.out.println("ERROR: Decoded bytes do not match original.");
        }
    }
}

