/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.layouters;

import java.util.Collection;
import java.util.TreeSet;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.info.FieldData;
import org.openjdk.jol.info.FieldLayout;
import org.openjdk.jol.layouters.Layouter;
import org.openjdk.jol.util.MathUtil;
import org.openjdk.jol.vm.VM;
import org.openjdk.jol.vm.VirtualMachine;

public class CurrentLayouter
implements Layouter {
    @Override
    public ClassLayout layout(ClassData data) {
        long instanceSize;
        VirtualMachine vm = VM.current();
        if (data.isArray()) {
            int base = vm.arrayBaseOffset(data.arrayComponentType());
            int scale = vm.arrayIndexScale(data.arrayComponentType());
            long instanceSize2 = MathUtil.align((long)base + data.arrayLength() * (long)scale, vm.objectAlignment());
            TreeSet<FieldLayout> result = new TreeSet<FieldLayout>();
            result.add(new FieldLayout(FieldData.create(data.arrayClass(), "<elements>", data.arrayComponentType()), base, (long)scale * data.arrayLength()));
            return new ClassLayout(data, result, vm.arrayHeaderSize(), instanceSize2, false);
        }
        Collection<FieldData> fields = data.fields();
        TreeSet<FieldLayout> result = new TreeSet<FieldLayout>();
        for (FieldData f : fields) {
            result.add(new FieldLayout(f, vm.fieldOffset(f.refField()), vm.sizeOfField(f.typeClass())));
        }
        if (result.isEmpty()) {
            instanceSize = vm.objectHeaderSize();
        } else {
            FieldLayout f = (FieldLayout)result.last();
            instanceSize = f.offset() + f.size();
        }
        instanceSize = MathUtil.align(instanceSize, vm.objectAlignment());
        return new ClassLayout(data, result, vm.objectHeaderSize(), instanceSize, true);
    }

    public String toString() {
        return "Current VM Layout";
    }
}

