/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.info;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openjdk.jol.info.ArrayGraphPathRecord;
import org.openjdk.jol.info.FieldGraphPathRecord;
import org.openjdk.jol.info.GraphLayout;
import org.openjdk.jol.info.GraphPathRecord;
import org.openjdk.jol.util.ObjectUtils;
import org.openjdk.jol.vm.VM;

public class GraphWalker {
    private final Map<Class<?>, Field[]> fieldsCache = new HashMap();
    private final Map<Class<?>, Long> sizeCache = new HashMap();

    public GraphLayout walk(Object ... roots) {
        Object e;
        GraphLayout data = new GraphLayout(new Object[0]);
        IdentityHashSet visited = new IdentityHashSet(4);
        ArrayDeque<GraphPathRecord> q = new ArrayDeque<GraphPathRecord>();
        int rootId = 1;
        boolean single = roots.length == 1;
        for (Object root : roots) {
            String label = single ? "" : "<r" + rootId + ">";
            e = new FieldGraphPathRecord(null, label, 0, root);
            if (visited.add(root)) {
                data.addRecord((GraphPathRecord)e);
                q.add((GraphPathRecord)e);
            }
            ++rootId;
        }
        while (!q.isEmpty()) {
            Field[] fields;
            GraphPathRecord cGpr = (GraphPathRecord)q.pop();
            Object o = cGpr.obj();
            Class<?> cl = o.getClass();
            if (cl.isArray()) {
                if (cl.getComponentType().isPrimitive()) continue;
                Object[] arr = (Object[])o;
                for (int i = 0; i < arr.length; ++i) {
                    e = arr[i];
                    if (e == null || !visited.add(e)) continue;
                    ArrayGraphPathRecord gpr = new ArrayGraphPathRecord(cGpr, i, cGpr.depth() + 1, e);
                    data.addRecord(gpr);
                    q.push(gpr);
                }
                continue;
            }
            Long knownSize = this.sizeCache.get(cl);
            if (knownSize == null) {
                knownSize = VM.current().sizeOf(o);
                this.sizeCache.put(cl, knownSize);
            }
            cGpr.setSize(knownSize);
            for (Field f : fields = this.getAllReferences(cl)) {
                Object e2 = ObjectUtils.value(o, f);
                if (e2 == null || !visited.add(e2)) continue;
                FieldGraphPathRecord gpr = new FieldGraphPathRecord(cGpr, f.getName(), cGpr.depth() + 1, e2);
                data.addRecord(gpr);
                q.push(gpr);
            }
        }
        return data;
    }

    private Field[] getAllReferences(Class<?> klass) {
        Field[] exist = this.fieldsCache.get(klass);
        if (exist != null) {
            return exist;
        }
        ArrayList<Field> results = new ArrayList<Field>();
        for (Field f : klass.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || f.getType().isPrimitive()) continue;
            results.add(f);
        }
        Class<?> superKlass = klass;
        while ((superKlass = superKlass.getSuperclass()) != null) {
            for (Field f : superKlass.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || f.getType().isPrimitive()) continue;
                results.add(f);
            }
        }
        Field[] arr = results.toArray(new Field[0]);
        this.fieldsCache.put(klass, arr);
        return arr;
    }

    private static final class IdentityHashSet {
        private static final int MINIMUM_CAPACITY = 4;
        private static final int MAXIMUM_CAPACITY = 0x20000000;
        private Object[] table;
        private int size;

        public IdentityHashSet(int expectedMaxSize) {
            this.table = new Object[IdentityHashSet.capacity(expectedMaxSize)];
        }

        private static int capacity(int expectedMaxSize) {
            return expectedMaxSize > 0xAAAAAAA ? 0x20000000 : (expectedMaxSize <= 2 ? 4 : Integer.highestOneBit(expectedMaxSize + (expectedMaxSize << 1)));
        }

        private static int hash(Object x, int length) {
            return System.identityHashCode(x) & length - 1;
        }

        private static int nextIndex(int i, int len) {
            return i + 1 < len ? i + 1 : 0;
        }

        public boolean add(Object o) {
            int len;
            int s;
            do {
                Object item;
                Object[] tab = this.table;
                len = tab.length;
                int i = IdentityHashSet.hash(o, len);
                while ((item = tab[i]) != null) {
                    if (item == o) {
                        return false;
                    }
                    i = IdentityHashSet.nextIndex(i, len);
                }
            } while ((s = this.size + 1) * 3 > len && this.resize(len));
            tab[i] = o;
            this.size = s;
            return true;
        }

        private boolean resize(int newCapacity) {
            int newLength = newCapacity * 2;
            Object[] oldTable = this.table;
            int oldLength = oldTable.length;
            if (oldLength == 0x40000000) {
                if (this.size == 0x1FFFFFFF) {
                    throw new IllegalStateException("Capacity exhausted.");
                }
                return false;
            }
            if (oldLength >= newLength) {
                return false;
            }
            Object[] newTable = new Object[newLength];
            for (Object o : oldTable) {
                if (o == null) continue;
                int i = IdentityHashSet.hash(o, newLength);
                while (newTable[i] != null) {
                    i = IdentityHashSet.nextIndex(i, newLength);
                }
                newTable[i] = o;
            }
            this.table = newTable;
            return true;
        }
    }
}

